/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.parser.core;

import java.util.LinkedList;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.distsql.parser.autogen.DistSQLStatementBaseVisitor;
import org.apache.shardingsphere.distsql.parser.autogen.DistSQLStatementParser;
import org.apache.shardingsphere.distsql.parser.segment.rdl.DataSourceConnectionSegment;
import org.apache.shardingsphere.distsql.parser.segment.rdl.TableRuleSegment;
import org.apache.shardingsphere.distsql.parser.statement.rdl.CreateDataSourcesStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.CreateShardingRuleStatement;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.sql.common.value.collection.CollectionValue;

public final class DistSQLVisitor
extends DistSQLStatementBaseVisitor<ASTNode> {
    @Override
    public ASTNode visitCreateDataSources(DistSQLStatementParser.CreateDataSourcesContext ctx) {
        LinkedList<DataSourceConnectionSegment> connectionInfos = new LinkedList<DataSourceConnectionSegment>();
        for (DistSQLStatementParser.DataSourceContext each : ctx.dataSource()) {
            connectionInfos.add((DataSourceConnectionSegment)this.visit((ParseTree)each));
        }
        return new CreateDataSourcesStatement(connectionInfos);
    }

    @Override
    public ASTNode visitDataSource(DistSQLStatementParser.DataSourceContext ctx) {
        DataSourceConnectionSegment result = (DataSourceConnectionSegment)this.visit((ParseTree)ctx.dataSourceDefinition());
        result.setName(ctx.dataSourceName().getText());
        return result;
    }

    @Override
    public ASTNode visitDataSourceDefinition(DistSQLStatementParser.DataSourceDefinitionContext ctx) {
        DataSourceConnectionSegment result = new DataSourceConnectionSegment();
        result.setHostName(ctx.hostName().getText());
        result.setPort(ctx.port().getText());
        result.setDb(ctx.dbName().getText());
        result.setUser(null == ctx.user() ? "" : ctx.user().getText());
        result.setPassword(null == ctx.password() ? "" : ctx.password().getText());
        return result;
    }

    @Override
    public ASTNode visitCreateShardingRule(DistSQLStatementParser.CreateShardingRuleContext ctx) {
        LinkedList<TableRuleSegment> tables = new LinkedList<TableRuleSegment>();
        for (DistSQLStatementParser.TableRuleContext each : ctx.tableRule()) {
            tables.add((TableRuleSegment)this.visit((ParseTree)each));
        }
        return new CreateShardingRuleStatement(tables);
    }

    @Override
    public ASTNode visitTableRule(DistSQLStatementParser.TableRuleContext ctx) {
        TableRuleSegment result = new TableRuleSegment();
        result.setLogicTable(ctx.tableName().getText());
        result.setAlgorithmType(ctx.tableRuleDefinition().strategyType().getText());
        result.setShardingColumn(ctx.tableRuleDefinition().strategyDefinition().columName().getText());
        result.setDataSources(new LinkedList());
        CollectionValue props = (CollectionValue)this.visit((ParseTree)ctx.tableRuleDefinition().strategyDefinition().strategyProps());
        result.setProperties(props.getValue());
        return result;
    }

    @Override
    public ASTNode visitStrategyProps(DistSQLStatementParser.StrategyPropsContext ctx) {
        CollectionValue result = new CollectionValue();
        for (DistSQLStatementParser.StrategyPropContext each : ctx.strategyProp()) {
            result.getValue().add(each.getText());
        }
        return result;
    }
}

