/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.payload;

import com.google.common.base.Strings;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.payload.PacketPayload;

public final class MySQLPacketPayload
implements PacketPayload {
    private final ByteBuf byteBuf;
    private final Charset charset;

    public int readInt1() {
        return this.byteBuf.readUnsignedByte();
    }

    public void writeInt1(int value) {
        this.byteBuf.writeByte(value);
    }

    public int readInt2() {
        return this.byteBuf.readUnsignedShortLE();
    }

    public void writeInt2(int value) {
        this.byteBuf.writeShortLE(value);
    }

    public int readInt3() {
        return this.byteBuf.readUnsignedMediumLE();
    }

    public void writeInt3(int value) {
        this.byteBuf.writeMediumLE(value);
    }

    public int readInt4() {
        return this.byteBuf.readIntLE();
    }

    public void writeInt4(int value) {
        this.byteBuf.writeIntLE(value);
    }

    public long readInt6() {
        long result = 0L;
        for (int i = 0; i < 6; ++i) {
            result |= (long)(0xFF & this.byteBuf.readByte()) << 8 * i;
        }
        return result;
    }

    public void writeInt6(long value) {
    }

    public long readInt8() {
        return this.byteBuf.readLongLE();
    }

    public void writeInt8(long value) {
        this.byteBuf.writeLongLE(value);
    }

    public long readIntLenenc() {
        int firstByte = this.readInt1();
        if (firstByte < 251) {
            return firstByte;
        }
        if (251 == firstByte) {
            return 0L;
        }
        if (252 == firstByte) {
            return this.readInt2();
        }
        if (253 == firstByte) {
            return this.readInt3();
        }
        return this.byteBuf.readLongLE();
    }

    public void writeIntLenenc(long value) {
        if (value < 251L) {
            this.byteBuf.writeByte((int)value);
            return;
        }
        if ((double)value < Math.pow(2.0, 16.0)) {
            this.byteBuf.writeByte(252);
            this.byteBuf.writeShortLE((int)value);
            return;
        }
        if ((double)value < Math.pow(2.0, 24.0)) {
            this.byteBuf.writeByte(253);
            this.byteBuf.writeMediumLE((int)value);
            return;
        }
        this.byteBuf.writeByte(254);
        this.byteBuf.writeLongLE(value);
    }

    public long readLong(int length) {
        long result = 0L;
        for (int i = 0; i < length; ++i) {
            result = result << 8 | (long)this.readInt1();
        }
        return result;
    }

    public String readStringLenenc() {
        int length = (int)this.readIntLenenc();
        byte[] result = new byte[length];
        this.byteBuf.readBytes(result);
        return new String(result, this.charset);
    }

    public byte[] readStringLenencByBytes() {
        int length = (int)this.readIntLenenc();
        byte[] result = new byte[length];
        this.byteBuf.readBytes(result);
        return result;
    }

    public void writeStringLenenc(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            this.byteBuf.writeByte(0);
            return;
        }
        byte[] valueBytes = value.getBytes(this.charset);
        this.writeIntLenenc(valueBytes.length);
        this.byteBuf.writeBytes(valueBytes);
    }

    public void writeBytesLenenc(byte[] value) {
        if (0 == value.length) {
            this.byteBuf.writeByte(0);
            return;
        }
        this.writeIntLenenc(value.length);
        this.byteBuf.writeBytes(value);
    }

    public String readStringFix(int length) {
        byte[] result = new byte[length];
        this.byteBuf.readBytes(result);
        return new String(result, this.charset);
    }

    public byte[] readStringFixByBytes(int length) {
        byte[] result = new byte[length];
        this.byteBuf.readBytes(result);
        return result;
    }

    public void writeStringFix(String value) {
        this.byteBuf.writeBytes(value.getBytes(this.charset));
    }

    public void writeBytes(byte[] value) {
        this.byteBuf.writeBytes(value);
    }

    public String readStringVar() {
        return "";
    }

    public void writeStringVar(String value) {
    }

    public String readStringNul() {
        byte[] result = new byte[this.byteBuf.bytesBefore((byte)0)];
        this.byteBuf.readBytes(result);
        this.byteBuf.skipBytes(1);
        return new String(result, this.charset);
    }

    public byte[] readStringNulByBytes() {
        byte[] result = new byte[this.byteBuf.bytesBefore((byte)0)];
        this.byteBuf.readBytes(result);
        this.byteBuf.skipBytes(1);
        return result;
    }

    public void writeStringNul(String value) {
        this.byteBuf.writeBytes(value.getBytes(this.charset));
        this.byteBuf.writeByte(0);
    }

    public byte[] readStringEOFByBytes() {
        byte[] result = new byte[this.byteBuf.readableBytes()];
        this.byteBuf.readBytes(result);
        return result;
    }

    public String readStringEOF() {
        byte[] result = new byte[this.byteBuf.readableBytes()];
        this.byteBuf.readBytes(result);
        return new String(result, this.charset);
    }

    public void writeStringEOF(String value) {
        this.byteBuf.writeBytes(value.getBytes(this.charset));
    }

    public void skipReserved(int length) {
        this.byteBuf.skipBytes(length);
    }

    public void writeReserved(int length) {
        this.byteBuf.writeZero(length);
    }

    public void close() {
        this.byteBuf.release();
    }

    @Generated
    public MySQLPacketPayload(ByteBuf byteBuf, Charset charset) {
        this.byteBuf = byteBuf;
        this.charset = charset;
    }

    @Generated
    public ByteBuf getByteBuf() {
        return this.byteBuf;
    }

    @Generated
    public Charset getCharset() {
        return this.charset;
    }
}

