/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.db.protocol.CommonConstants;
import org.apache.shardingsphere.db.protocol.codec.DatabasePacketCodecEngine;
import org.apache.shardingsphere.db.protocol.mysql.packet.MySQLPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLErrPacket;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;
import org.apache.shardingsphere.infra.util.exception.sql.UnknownSQLException;

public final class MySQLPacketCodecEngine
implements DatabasePacketCodecEngine<MySQLPacket> {
    private static final int MAX_PACKET_LENGTH = 0xFFFFFF;
    private static final int PAYLOAD_LENGTH = 3;
    private static final int SEQUENCE_LENGTH = 1;
    private final List<ByteBuf> pendingMessages = new LinkedList<ByteBuf>();

    public boolean isValidHeader(int readableBytes) {
        return readableBytes >= 4;
    }

    public void decode(ChannelHandlerContext context, ByteBuf in, List<Object> out) {
        int payloadLength = in.markReaderIndex().readUnsignedMediumLE();
        int remainPayloadLength = 1 + payloadLength;
        if (in.readableBytes() < remainPayloadLength) {
            in.resetReaderIndex();
            return;
        }
        ByteBuf message = in.readRetainedSlice(1 + payloadLength);
        if (0xFFFFFF == payloadLength) {
            this.pendingMessages.add(message);
        } else if (this.pendingMessages.isEmpty()) {
            out.add(message);
        } else {
            this.aggregateMessages(context, message, out);
        }
    }

    private void aggregateMessages(ChannelHandlerContext context, ByteBuf lastMessage, List<Object> out) {
        CompositeByteBuf result = context.alloc().compositeBuffer(this.pendingMessages.size() + 1);
        Iterator<ByteBuf> pendingMessagesIterator = this.pendingMessages.iterator();
        result.addComponent(true, pendingMessagesIterator.next());
        while (pendingMessagesIterator.hasNext()) {
            result.addComponent(true, pendingMessagesIterator.next().skipBytes(1));
        }
        if (lastMessage.readableBytes() > 1) {
            result.addComponent(true, lastMessage.skipBytes(1));
        }
        out.add(result);
        this.pendingMessages.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(ChannelHandlerContext context, MySQLPacket message, ByteBuf out) {
        MySQLPacketPayload payload = new MySQLPacketPayload(this.prepareMessageHeader(out).markWriterIndex(), (Charset)context.channel().attr(CommonConstants.CHARSET_ATTRIBUTE_KEY).get());
        try {
            message.write(payload);
        }
        catch (Exception ex) {
            out.resetWriterIndex();
            SQLException unknownSQLException = new UnknownSQLException(ex).toSQLException();
            new MySQLErrPacket(1, unknownSQLException.getErrorCode(), unknownSQLException.getSQLState(), unknownSQLException.getMessage()).write(payload);
        }
        finally {
            this.updateMessageHeader(out, message.getSequenceId());
        }
    }

    private ByteBuf prepareMessageHeader(ByteBuf out) {
        return out.writeInt(0);
    }

    private void updateMessageHeader(ByteBuf byteBuf, int sequenceId) {
        byteBuf.setMediumLE(0, byteBuf.readableBytes() - 3 - 1);
        byteBuf.setByte(3, sequenceId);
    }

    public MySQLPacketPayload createPacketPayload(ByteBuf message, Charset charset) {
        return new MySQLPacketPayload(message, charset);
    }
}

