/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.opengauss;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.dbdiscovery.spi.DatabaseDiscoveryType;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.rule.event.impl.DataSourceDisabledEvent;
import org.apache.shardingsphere.infra.rule.event.impl.PrimaryDataSourceChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenGaussDatabaseDiscoveryType
implements DatabaseDiscoveryType {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenGaussDatabaseDiscoveryType.class);
    private static final String DB_ROLE = "SELECT local_role,db_state FROM pg_stat_get_stream_replications()";
    private String oldPrimaryDataSource;
    private Properties props = new Properties();

    public void checkDatabaseDiscoveryConfiguration(String schemaName, Map<String, DataSource> dataSourceMap) {
    }

    public void updatePrimaryDataSource(String schemaName, Map<String, DataSource> dataSourceMap, Collection<String> disabledDataSourceNames, String groupName) {
        String newPrimaryDataSource = this.determinePrimaryDataSource(dataSourceMap);
        if (newPrimaryDataSource.isEmpty()) {
            this.oldPrimaryDataSource = "";
            return;
        }
        if (!newPrimaryDataSource.equals(this.oldPrimaryDataSource)) {
            this.oldPrimaryDataSource = newPrimaryDataSource;
            ShardingSphereEventBus.getInstance().post((Object)new PrimaryDataSourceChangedEvent(schemaName, groupName, newPrimaryDataSource));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String determinePrimaryDataSource(Map<String, DataSource> dataSourceMap) {
        String result = "";
        Iterator<Map.Entry<String, DataSource>> iterator = dataSourceMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, DataSource> entry = iterator.next();
            try {
                Connection connection = entry.getValue().getConnection();
                Throwable throwable = null;
                try {
                    Statement statement = connection.createStatement();
                    Throwable throwable2 = null;
                    try {
                        ResultSet resultSet = statement.executeQuery(DB_ROLE);
                        Throwable throwable3 = null;
                        try {
                            if (!resultSet.next() || !resultSet.getString("local_role").equals("Primary") || !resultSet.getString("db_state").equals("Normal")) continue;
                            String string = entry.getKey();
                            return string;
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (resultSet == null) continue;
                            if (throwable3 != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable3.addSuppressed(throwable5);
                                }
                                continue;
                            }
                            resultSet.close();
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable2 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (statement == null) continue;
                        if (throwable2 != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable7) {
                                throwable2.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        statement.close();
                    }
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
                finally {
                    if (connection == null) continue;
                    if (throwable != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                        continue;
                    }
                    connection.close();
                }
            }
            catch (SQLException ex) {
                log.error("An exception occurred while find primary data source url", (Throwable)ex);
            }
        }
        return result;
    }

    public void updateMemberState(String schemaName, Map<String, DataSource> dataSourceMap, Collection<String> disabledDataSourceNames) {
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            boolean disable = true;
            try (Connection connection = entry.getValue().getConnection();
                 Statement statement = connection.createStatement();
                 ResultSet resultSet = statement.executeQuery(DB_ROLE);){
                if (resultSet.next() && (resultSet.getString("local_role").equals("Standby") && resultSet.getString("db_state").equals("Normal") || entry.getKey().equals(this.oldPrimaryDataSource))) {
                    disable = false;
                }
            }
            catch (SQLException ex) {
                log.error("An exception occurred while find data source urls", (Throwable)ex);
            }
            ShardingSphereEventBus.getInstance().post((Object)new DataSourceDisabledEvent(schemaName, entry.getKey(), disable));
        }
    }

    public String getPrimaryDataSource() {
        return this.oldPrimaryDataSource;
    }

    public String getType() {
        return "openGauss";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }
}

