/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.mysql.type;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.dbdiscovery.mysql.AbstractDatabaseDiscoveryType;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.rule.event.impl.DataSourceDisabledEvent;
import org.apache.shardingsphere.infra.storage.StorageNodeDataSource;
import org.apache.shardingsphere.infra.storage.StorageNodeRole;
import org.apache.shardingsphere.infra.storage.StorageNodeStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShowSlaveStatusDatabaseDiscoveryType
extends AbstractDatabaseDiscoveryType {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShowSlaveStatusDatabaseDiscoveryType.class);
    private static final String SHOW_SLAVE_STATUS = "SHOW SLAVE STATUS";
    private Properties props = new Properties();

    public void checkDatabaseDiscoveryConfiguration(String schemaName, Map<String, DataSource> dataSourceMap) throws SQLException {
        Collection<String> result = this.getPrimaryDataSourceURLS(dataSourceMap);
        Preconditions.checkState((!result.isEmpty() ? 1 : 0) != 0, (String)"Not found primary data source for schemaName `%s`", (Object)schemaName);
        Preconditions.checkState((1 == result.size() ? 1 : 0) != 0, (String)"More than one primary data source for schemaName `%s`", (Object)schemaName);
    }

    private Collection<String> getPrimaryDataSourceURLS(Map<String, DataSource> dataSourceMap) throws SQLException {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            Connection connection = entry.getValue().getConnection();
            Throwable throwable = null;
            try {
                Statement statement = connection.createStatement();
                Throwable throwable2 = null;
                try {
                    String url = this.getPrimaryDataSourceURL(statement);
                    if (url.isEmpty() || result.contains(url)) continue;
                    result.add(url);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (statement == null) continue;
                    if (throwable2 != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    statement.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (connection == null) continue;
                if (throwable != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                connection.close();
            }
        }
        return result;
    }

    @Override
    protected String getPrimaryDataSourceURL(Statement statement) throws SQLException {
        try (ResultSet resultSet = statement.executeQuery(SHOW_SLAVE_STATUS);){
            if (resultSet.next()) {
                String masterHost = resultSet.getString("Master_Host");
                String masterPort = resultSet.getString("Master_Port");
                if (null != masterHost && null != masterPort) {
                    String string = String.format("%s:%s", masterHost, masterPort);
                    return string;
                }
            }
            String string = "";
            return string;
        }
    }

    public void updateMemberState(String schemaName, Map<String, DataSource> dataSourceMap, String groupName) {
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            if (entry.getKey().equals(this.getPrimaryDataSource())) continue;
            this.determineDatasourceState(schemaName, entry.getKey(), entry.getValue(), groupName);
        }
    }

    private void determineDatasourceState(String schemaName, String datasourceName, DataSource dataSource, String groupName) {
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();){
            long replicationDelayMilliseconds = this.getSecondsBehindMaster(statement) * 1000L;
            if (replicationDelayMilliseconds < Long.parseLong(this.props.getProperty("delay-milliseconds-threshold"))) {
                ShardingSphereEventBus.getInstance().post((Object)new DataSourceDisabledEvent(schemaName, groupName, datasourceName, new StorageNodeDataSource(StorageNodeRole.MEMBER, StorageNodeStatus.ENABLED, Long.valueOf(replicationDelayMilliseconds))));
            } else {
                ShardingSphereEventBus.getInstance().post((Object)new DataSourceDisabledEvent(schemaName, groupName, datasourceName, new StorageNodeDataSource(StorageNodeRole.MEMBER, StorageNodeStatus.DISABLED, Long.valueOf(replicationDelayMilliseconds))));
            }
        }
        catch (SQLException ex) {
            log.error("An exception occurred while find member data source `Seconds_Behind_Master`", (Throwable)ex);
        }
    }

    private long getSecondsBehindMaster(Statement statement) throws SQLException {
        try (ResultSet resultSet = statement.executeQuery(SHOW_SLAVE_STATUS);){
            if (resultSet.next()) {
                long l = resultSet.getLong("Seconds_Behind_Master");
                return l;
            }
            long l = 0L;
            return l;
        }
    }

    public String getType() {
        return "SHOW_SLAVE_STATUS";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }
}

