/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.migration.config.yaml.swapper;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.data.pipeline.api.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.core.datanode.JobDataNodeLine;
import org.apache.shardingsphere.data.pipeline.core.datasource.yaml.config.YamlPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.core.datasource.yaml.swapper.YamlPipelineDataSourceConfigurationSwapper;
import org.apache.shardingsphere.data.pipeline.core.job.config.yaml.swapper.YamlPipelineJobConfigurationSwapper;
import org.apache.shardingsphere.data.pipeline.scenario.migration.config.MigrationJobConfiguration;
import org.apache.shardingsphere.data.pipeline.scenario.migration.config.yaml.config.YamlMigrationJobConfiguration;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;

public final class YamlMigrationJobConfigurationSwapper
implements YamlPipelineJobConfigurationSwapper<YamlMigrationJobConfiguration, MigrationJobConfiguration> {
    private final YamlPipelineDataSourceConfigurationSwapper dataSourceConfigSwapper = new YamlPipelineDataSourceConfigurationSwapper();

    public YamlMigrationJobConfiguration swapToYamlConfiguration(MigrationJobConfiguration data) {
        YamlMigrationJobConfiguration result = new YamlMigrationJobConfiguration();
        result.setJobId(data.getJobId());
        result.setTargetDatabaseName(data.getTargetDatabaseName());
        result.setSourceDatabaseType(data.getSourceDatabaseType().getType());
        result.setTargetDatabaseType(data.getTargetDatabaseType().getType());
        result.setSources(data.getSources().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.dataSourceConfigSwapper.swapToYamlConfiguration((PipelineDataSourceConfiguration)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new)));
        result.setTarget(this.dataSourceConfigSwapper.swapToYamlConfiguration(data.getTarget()));
        result.setTargetTableNames(data.getTargetTableNames());
        result.setTargetTableSchemaMap(data.getTargetTableSchemaMap());
        result.setTablesFirstDataNodes(data.getTablesFirstDataNodes().marshal());
        result.setJobShardingDataNodes(data.getJobShardingDataNodes().stream().map(JobDataNodeLine::marshal).collect(Collectors.toList()));
        result.setConcurrency(data.getConcurrency());
        result.setRetryTimes(data.getRetryTimes());
        return result;
    }

    public MigrationJobConfiguration swapToObject(YamlMigrationJobConfiguration yamlConfig) {
        return new MigrationJobConfiguration(yamlConfig.getJobId(), yamlConfig.getDatabaseName(), (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)yamlConfig.getSourceDatabaseType()), (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)yamlConfig.getTargetDatabaseType()), yamlConfig.getSources().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.dataSourceConfigSwapper.swapToObject((YamlPipelineDataSourceConfiguration)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new)), this.dataSourceConfigSwapper.swapToObject(yamlConfig.getTarget()), yamlConfig.getTargetTableNames(), yamlConfig.getTargetTableSchemaMap(), JobDataNodeLine.unmarshal((String)yamlConfig.getTablesFirstDataNodes()), yamlConfig.getJobShardingDataNodes().stream().map(JobDataNodeLine::unmarshal).collect(Collectors.toList()), yamlConfig.getConcurrency(), yamlConfig.getRetryTimes());
    }

    public MigrationJobConfiguration swapToObject(String jobParam) {
        return this.swapToObject((YamlMigrationJobConfiguration)YamlEngine.unmarshal((String)jobParam, YamlMigrationJobConfiguration.class, (boolean)true));
    }
}

