/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.opengauss.ingest.wal.decode;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.constant.PipelineSQLOperationType;
import org.apache.shardingsphere.data.pipeline.core.exception.IngestException;
import org.apache.shardingsphere.data.pipeline.opengauss.ingest.wal.decode.MppTableData;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.decode.BaseLogSequenceNumber;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.decode.BaseTimestampUtils;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.decode.DecodingException;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.decode.DecodingPlugin;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.event.AbstractRowEvent;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.event.AbstractWALEvent;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.event.BeginTXEvent;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.event.CommitTXEvent;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.event.DeleteRowEvent;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.event.PlaceholderEvent;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.event.UpdateRowEvent;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.event.WriteRowEvent;
import org.apache.shardingsphere.infra.util.json.JsonUtils;
import org.opengauss.util.PGInterval;
import org.opengauss.util.PGobject;

public final class MppdbDecodingPlugin
implements DecodingPlugin {
    private final BaseTimestampUtils timestampUtils;
    private final boolean decodeWithTX;
    private final boolean decodeParallelly;

    public AbstractWALEvent decode(ByteBuffer data, BaseLogSequenceNumber logSequenceNumber) {
        byte[] bytes = new byte[data.remaining()];
        data.get(bytes);
        String dataText = new String(bytes, StandardCharsets.UTF_8);
        AbstractWALEvent result = this.decodeWithTX ? this.decodeDataWithTX(dataText) : this.decodeDataIgnoreTX(dataText);
        result.setLogSequenceNumber(logSequenceNumber);
        return result;
    }

    private AbstractWALEvent decodeDataWithTX(String dataText) {
        if (this.decodeParallelly) {
            return this.decodeParallelly(dataText);
        }
        return this.decodeSerially(dataText);
    }

    private AbstractWALEvent decodeSerially(String dataText) {
        PlaceholderEvent result = new PlaceholderEvent();
        if (dataText.startsWith("BEGIN")) {
            int beginIndex = dataText.indexOf("BEGIN") + "BEGIN".length() + 1;
            result = new BeginTXEvent(Long.valueOf(Long.parseLong(dataText.substring(beginIndex))), null);
        } else if (dataText.startsWith("COMMIT")) {
            int commitBeginIndex = dataText.indexOf("COMMIT") + "COMMIT".length() + 1;
            int csnBeginIndex = dataText.indexOf("CSN") + "CSN".length() + 1;
            result = new CommitTXEvent(Long.parseLong(dataText.substring(commitBeginIndex, dataText.indexOf(32, commitBeginIndex))), Long.valueOf(Long.parseLong(dataText.substring(csnBeginIndex))));
        } else if (dataText.startsWith("{")) {
            result = this.readTableEvent(dataText);
        }
        return result;
    }

    private AbstractWALEvent decodeParallelly(String dataText) {
        PlaceholderEvent result = new PlaceholderEvent();
        if (dataText.startsWith("BEGIN")) {
            int beginIndex = dataText.indexOf("CSN:") + "CSN:".length() + 1;
            int firstLsnIndex = dataText.indexOf("first_lsn");
            long csn = firstLsnIndex > 0 ? Long.parseLong(dataText.substring(beginIndex, firstLsnIndex - 1)) : 0L;
            result = new BeginTXEvent(null, Long.valueOf(csn));
        } else if (dataText.startsWith("commit") || dataText.startsWith("COMMIT")) {
            int beginIndex = dataText.indexOf("xid:") + "xid:".length() + 1;
            result = new CommitTXEvent(Long.parseLong(dataText.substring(beginIndex)), null);
        } else if (dataText.startsWith("{")) {
            result = this.readTableEvent(dataText);
        }
        return result;
    }

    private AbstractWALEvent decodeDataIgnoreTX(String dataText) {
        return dataText.startsWith("{") ? this.readTableEvent(dataText) : new PlaceholderEvent();
    }

    private AbstractRowEvent readTableEvent(String mppData) {
        AbstractRowEvent result;
        PipelineSQLOperationType type;
        MppTableData mppTableData = (MppTableData)JsonUtils.fromJsonString((String)mppData, MppTableData.class);
        String rowEventType = mppTableData.getOpType();
        try {
            type = PipelineSQLOperationType.valueOf((String)rowEventType);
        }
        catch (IllegalArgumentException ex) {
            throw new IngestException("Unknown rowEventType: " + rowEventType);
        }
        switch (type) {
            case INSERT: {
                result = this.readWriteRowEvent(mppTableData);
                break;
            }
            case UPDATE: {
                result = this.readUpdateRowEvent(mppTableData);
                break;
            }
            case DELETE: {
                result = this.readDeleteRowEvent(mppTableData);
                break;
            }
            default: {
                throw new IngestException("Unknown rowEventType: " + rowEventType);
            }
        }
        String[] tableMetaData = mppTableData.getTableName().split("\\.");
        result.setSchemaName(tableMetaData[0]);
        result.setTableName(tableMetaData[1]);
        return result;
    }

    private AbstractRowEvent readWriteRowEvent(MppTableData data) {
        WriteRowEvent result = new WriteRowEvent();
        result.setAfterRow(this.getColumnDataFromMppDataEvent(data));
        return result;
    }

    private AbstractRowEvent readUpdateRowEvent(MppTableData data) {
        UpdateRowEvent result = new UpdateRowEvent();
        result.setAfterRow(this.getColumnDataFromMppDataEvent(data));
        return result;
    }

    private AbstractRowEvent readDeleteRowEvent(MppTableData data) {
        DeleteRowEvent result = new DeleteRowEvent();
        result.setPrimaryKeys(this.getDeleteColumnDataFromMppDataEvent(data));
        return result;
    }

    private List<Object> getColumnDataFromMppDataEvent(MppTableData data) {
        ArrayList<Object> result = new ArrayList<Object>(data.getColumnsType().length);
        for (int i = 0; i < data.getColumnsType().length; ++i) {
            result.add(this.readColumnData(data.getColumnsVal()[i], data.getColumnsType()[i]));
        }
        return result;
    }

    private List<Object> getDeleteColumnDataFromMppDataEvent(MppTableData data) {
        ArrayList<Object> result = new ArrayList<Object>(data.getOldKeysType().length);
        for (int i = 0; i < data.getOldKeysType().length; ++i) {
            result.add(this.readColumnData(data.getOldKeysVal()[i], data.getOldKeysType()[i]));
        }
        return result;
    }

    private Object readColumnData(String data, String columnType) {
        if ("null".equals(data)) {
            return null;
        }
        if (columnType.startsWith("numeric")) {
            return new BigDecimal(data);
        }
        if (columnType.startsWith("bit")) {
            return this.decodeString(data.substring(1));
        }
        switch (columnType) {
            case "tinyint": 
            case "smallint": 
            case "integer": {
                return Integer.parseInt(data);
            }
            case "bigint": {
                return Long.parseLong(data);
            }
            case "real": {
                return Float.valueOf(Float.parseFloat(data));
            }
            case "double precision": {
                return Double.parseDouble(data);
            }
            case "boolean": {
                return Boolean.parseBoolean(data);
            }
            case "time without time zone": 
            case "time with time zone": {
                try {
                    return this.timestampUtils.toTime(null, this.decodeString(data));
                }
                catch (SQLException ex) {
                    throw new DecodingException((Throwable)ex);
                }
            }
            case "date": {
                return Date.valueOf(this.decodeString(data));
            }
            case "timestamp without time zone": 
            case "timestamp with time zone": 
            case "smalldatetime": {
                try {
                    return this.timestampUtils.toTimestamp(null, this.decodeString(data));
                }
                catch (SQLException ex) {
                    throw new DecodingException((Throwable)ex);
                }
            }
            case "bytea": 
            case "blob": {
                return this.decodeBytea(data);
            }
            case "raw": 
            case "reltime": 
            case "int4range": 
            case "int8range": 
            case "numrange": 
            case "tsrange": 
            case "tstzrange": 
            case "daterange": {
                return this.decodePgObject(data, columnType);
            }
            case "money": {
                return this.decodeMoney(data);
            }
            case "interval": {
                return this.decodeInterval(data);
            }
        }
        return this.decodeString(data).replace("''", "'");
    }

    private PGobject decodeInterval(String data) {
        try {
            return new PGInterval(this.decodeString(data));
        }
        catch (SQLException ignored) {
            return null;
        }
    }

    private PGobject decodePgObject(String data, String type) {
        try {
            PGobject result = new PGobject();
            result.setType(type);
            result.setValue(this.decodeString(data));
            return result;
        }
        catch (SQLException ignored) {
            return null;
        }
    }

    private Object decodeBytea(String data) {
        return this.decodeHex(this.decodeString(data).substring(2));
    }

    private String decodeMoney(String data) {
        String result = this.decodeString(data);
        return '$' == result.charAt(0) ? result.substring(1) : result;
    }

    private String decodeString(String data) {
        if (data.length() > 1) {
            int begin = '\'' == data.charAt(0) ? 1 : 0;
            int end = data.length() + (data.charAt(data.length() - 1) == '\'' ? -1 : 0);
            return data.substring(begin, end);
        }
        return data;
    }

    private byte[] decodeHex(String hexString) {
        int dataLength = hexString.length();
        Preconditions.checkArgument((0 == (dataLength & 1) ? 1 : 0) != 0, (String)"Illegal hex data `%s`", (Object)hexString);
        if (0 == dataLength) {
            return new byte[0];
        }
        byte[] result = new byte[dataLength >>> 1];
        for (int i = 0; i < dataLength; i += 2) {
            result[i >>> 1] = this.decodeHexByte(hexString, i);
        }
        return result;
    }

    private byte decodeHexByte(String hexString, int index) {
        int firstHexChar = Character.digit(hexString.charAt(index), 16);
        int secondHexChar = Character.digit(hexString.charAt(index + 1), 16);
        Preconditions.checkArgument((-1 != firstHexChar && -1 != secondHexChar ? 1 : 0) != 0, (String)"Illegal hex byte `%s` in index `%d`", (Object)hexString, (int)index);
        return (byte)((firstHexChar << 4) + secondHexChar);
    }

    @Generated
    public MppdbDecodingPlugin(BaseTimestampUtils timestampUtils, boolean decodeWithTX, boolean decodeParallelly) {
        this.timestampUtils = timestampUtils;
        this.decodeWithTX = decodeWithTX;
        this.decodeParallelly = decodeParallelly;
    }
}

