/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.opengauss.ingest;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.DialectIngestPositionManager;
import org.apache.shardingsphere.data.pipeline.opengauss.ingest.wal.decode.OpenGaussLogSequenceNumber;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.pojo.ReplicationSlotInfo;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.WALPosition;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.decode.BaseLogSequenceNumber;
import org.opengauss.replication.LogSequenceNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenGaussIngestPositionManager
implements DialectIngestPositionManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenGaussIngestPositionManager.class);
    private static final String SLOT_NAME_PREFIX = "pipeline";
    private static final String DECODE_PLUGIN = "mppdb_decoding";
    private static final String DUPLICATE_OBJECT_ERROR_CODE = "42710";

    public WALPosition init(DataSource dataSource, String slotNameSuffix) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            this.createSlotIfNotExist(connection, slotNameSuffix);
            WALPosition wALPosition = this.getWalPosition(connection);
            return wALPosition;
        }
    }

    public WALPosition init(String data) {
        return new WALPosition((BaseLogSequenceNumber)new OpenGaussLogSequenceNumber(LogSequenceNumber.valueOf((String)data)));
    }

    private void createSlotIfNotExist(Connection connection, String slotNameSuffix) throws SQLException {
        String slotName = OpenGaussIngestPositionManager.getUniqueSlotName(connection, slotNameSuffix);
        Optional<ReplicationSlotInfo> slotInfo = this.getSlotInfo(connection, slotName);
        if (!slotInfo.isPresent()) {
            this.createSlotBySQL(connection, slotName);
            return;
        }
        if (null == slotInfo.get().getDatabaseName()) {
            this.dropSlotIfExist(connection, slotName);
            this.createSlotBySQL(connection, slotName);
        }
    }

    private Optional<ReplicationSlotInfo> getSlotInfo(Connection connection, String slotName) throws SQLException {
        String sql = "SELECT slot_name, database FROM pg_replication_slots WHERE slot_name=? AND plugin=?";
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            Optional<ReplicationSlotInfo> optional;
            block16: {
                ResultSet resultSet;
                block14: {
                    Optional<ReplicationSlotInfo> optional2;
                    block15: {
                        preparedStatement.setString(1, slotName);
                        preparedStatement.setString(2, DECODE_PLUGIN);
                        resultSet = preparedStatement.executeQuery();
                        try {
                            if (resultSet.next()) break block14;
                            optional2 = Optional.empty();
                            if (resultSet == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return optional2;
                }
                optional = Optional.of(new ReplicationSlotInfo(resultSet.getString(1), resultSet.getString(2)));
                if (resultSet == null) break block16;
                resultSet.close();
            }
            return optional;
        }
    }

    private void createSlotBySQL(Connection connection, String slotName) throws SQLException {
        block8: {
            String sql = String.format("SELECT * FROM pg_create_logical_replication_slot('%s', '%s')", slotName, DECODE_PLUGIN);
            try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
                preparedStatement.execute();
            }
            catch (SQLException ex) {
                if (DUPLICATE_OBJECT_ERROR_CODE.equals(ex.getSQLState())) break block8;
                throw ex;
            }
        }
    }

    private WALPosition getWalPosition(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT PG_CURRENT_XLOG_LOCATION()");){
            WALPosition wALPosition;
            block12: {
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    resultSet.next();
                    wALPosition = new WALPosition((BaseLogSequenceNumber)new OpenGaussLogSequenceNumber(LogSequenceNumber.valueOf((String)resultSet.getString(1))));
                    if (resultSet == null) break block12;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return wALPosition;
        }
    }

    public void destroy(DataSource dataSource, String slotNameSuffix) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            this.dropSlotIfExist(connection, OpenGaussIngestPositionManager.getUniqueSlotName(connection, slotNameSuffix));
        }
    }

    private void dropSlotIfExist(Connection connection, String slotName) throws SQLException {
        if (!this.getSlotInfo(connection, slotName).isPresent()) {
            log.info("dropSlotIfExist, slot not exist, ignore, slotName={}", (Object)slotName);
            return;
        }
        String sql = String.format("select * from pg_drop_replication_slot('%s')", slotName);
        try (CallableStatement callableStatement = connection.prepareCall(sql);){
            callableStatement.execute();
        }
    }

    public static String getUniqueSlotName(Connection connection, String slotNameSuffix) throws SQLException {
        String slotName = DigestUtils.md5Hex((byte[])String.join((CharSequence)"_", connection.getCatalog(), slotNameSuffix).getBytes());
        return String.format("%s_%s", SLOT_NAME_PREFIX, slotName);
    }

    public String getDatabaseType() {
        return "openGauss";
    }
}

