/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.util;

import com.zaxxer.hikari.HikariDataSource;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.shardingsphere.core.config.DataSourceConfiguration;
import org.apache.shardingsphere.shardingproxy.config.yaml.YamlDataSourceParameter;

public final class DataSourceConverter {
    public static Map<String, YamlDataSourceParameter> getDataSourceParameterMap(Map<String, DataSourceConfiguration> dataSourceConfigurationMap) {
        LinkedHashMap<String, YamlDataSourceParameter> result = new LinkedHashMap<String, YamlDataSourceParameter>(dataSourceConfigurationMap.size(), 1.0f);
        for (Map.Entry<String, DataSourceConfiguration> entry : dataSourceConfigurationMap.entrySet()) {
            result.put(entry.getKey(), DataSourceConverter.createDataSourceParameter(entry.getValue()));
        }
        return result;
    }

    private static YamlDataSourceParameter createDataSourceParameter(DataSourceConfiguration dataSourceConfiguration) {
        YamlDataSourceParameter result = new YamlDataSourceParameter();
        for (Field each : result.getClass().getDeclaredFields()) {
            try {
                each.setAccessible(true);
                if (!dataSourceConfiguration.getProperties().containsKey(each.getName())) continue;
                each.set(result, dataSourceConfiguration.getProperties().get(each.getName()));
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return result;
    }

    public static Map<String, DataSourceConfiguration> getDataSourceConfigurationMap(Map<String, YamlDataSourceParameter> dataSourceParameterMap) {
        LinkedHashMap<String, DataSourceConfiguration> result = new LinkedHashMap<String, DataSourceConfiguration>(dataSourceParameterMap.size());
        for (Map.Entry<String, YamlDataSourceParameter> entry : dataSourceParameterMap.entrySet()) {
            result.put(entry.getKey(), DataSourceConverter.createDataSourceConfiguration(entry.getValue()));
        }
        return result;
    }

    private static DataSourceConfiguration createDataSourceConfiguration(YamlDataSourceParameter dataSourceParameter) {
        DataSourceConfiguration result = new DataSourceConfiguration(HikariDataSource.class.getName());
        result.getProperties().put("url", dataSourceParameter.getUrl());
        result.getProperties().put("username", dataSourceParameter.getUsername());
        result.getProperties().put("password", dataSourceParameter.getPassword());
        result.getProperties().put("connectionTimeoutMilliseconds", dataSourceParameter.getConnectionTimeoutMilliseconds());
        result.getProperties().put("idleTimeoutMilliseconds", dataSourceParameter.getIdleTimeoutMilliseconds());
        result.getProperties().put("maxLifetimeMilliseconds", dataSourceParameter.getMaxLifetimeMilliseconds());
        result.getProperties().put("maxPoolSize", dataSourceParameter.getMaxPoolSize());
        result.getProperties().put("minPoolSize", dataSourceParameter.getMinPoolSize());
        result.getProperties().put("maintenanceIntervalMilliseconds", dataSourceParameter.getMaintenanceIntervalMilliseconds());
        result.getProperties().put("readOnly", dataSourceParameter.isReadOnly());
        return result;
    }

    private DataSourceConverter() {
    }
}

