/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.config;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.apache.shardingsphere.core.yaml.engine.YamlEngine;
import org.apache.shardingsphere.shardingproxy.config.ShardingConfiguration;
import org.apache.shardingsphere.shardingproxy.config.yaml.YamlProxyRuleConfiguration;
import org.apache.shardingsphere.shardingproxy.config.yaml.YamlProxyServerConfiguration;

public final class ShardingConfigurationLoader {
    private static final String DEFAULT_DATASOURCE_NAME = "dataSource";
    private static final String CONFIG_PATH = "/conf/";
    private static final String SERVER_CONFIG_FILE = "server.yaml";
    private static final Pattern RULE_CONFIG_FILE_PATTERN = Pattern.compile("config-.+\\.yaml");

    /*
     * WARNING - void declaration
     */
    public ShardingConfiguration load() throws IOException {
        void var7_9;
        HashSet<String> schemaNames = new HashSet<String>();
        YamlProxyServerConfiguration serverConfig = this.loadServerConfiguration(new File(ShardingConfigurationLoader.class.getResource("/conf/server.yaml").getFile()));
        File configPath = new File(ShardingConfigurationLoader.class.getResource(CONFIG_PATH).getFile());
        LinkedList<Object> ruleConfigurations = new LinkedList<Object>();
        File[] fileArray = this.findRuleConfigurationFiles(configPath);
        int n = fileArray.length;
        boolean bl = false;
        while (var7_9 < n) {
            File each = fileArray[var7_9];
            Optional<YamlProxyRuleConfiguration> ruleConfig = this.loadRuleConfiguration(each, serverConfig);
            if (ruleConfig.isPresent()) {
                Preconditions.checkState((boolean)schemaNames.add(((YamlProxyRuleConfiguration)ruleConfig.get()).getSchemaName()), (String)"Schema name `%s` must unique at all rule configurations.", (Object[])new Object[]{((YamlProxyRuleConfiguration)ruleConfig.get()).getSchemaName()});
                ruleConfigurations.add(ruleConfig.get());
            }
            ++var7_9;
        }
        Preconditions.checkState((!ruleConfigurations.isEmpty() || null != serverConfig.getOrchestration() ? 1 : 0) != 0, (String)"Can not find any sharding rule configuration file in path `%s`.", (Object[])new Object[]{configPath.getPath()});
        HashMap<String, YamlProxyRuleConfiguration> ruleConfigurationMap = new HashMap<String, YamlProxyRuleConfiguration>(ruleConfigurations.size(), 1.0f);
        for (YamlProxyRuleConfiguration yamlProxyRuleConfiguration : ruleConfigurations) {
            ruleConfigurationMap.put(yamlProxyRuleConfiguration.getSchemaName(), yamlProxyRuleConfiguration);
        }
        return new ShardingConfiguration(serverConfig, ruleConfigurationMap);
    }

    private YamlProxyServerConfiguration loadServerConfiguration(File yamlFile) throws IOException {
        YamlProxyServerConfiguration result = (YamlProxyServerConfiguration)YamlEngine.unmarshal((File)yamlFile, YamlProxyServerConfiguration.class);
        Preconditions.checkNotNull((Object)result, (String)"Server configuration file `%s` is invalid.", (Object[])new Object[]{yamlFile.getName()});
        Preconditions.checkState((null != result.getAuthentication() || null != result.getOrchestration() ? 1 : 0) != 0, (Object)"Authority configuration is invalid.");
        return result;
    }

    private Optional<YamlProxyRuleConfiguration> loadRuleConfiguration(File yamlFile, YamlProxyServerConfiguration serverConfiguration) throws IOException {
        YamlProxyRuleConfiguration result = (YamlProxyRuleConfiguration)YamlEngine.unmarshal((File)yamlFile, YamlProxyRuleConfiguration.class);
        if (null == result) {
            return Optional.absent();
        }
        Preconditions.checkNotNull((Object)result.getSchemaName(), (String)"Property `schemaName` in file `%s` is required.", (Object[])new Object[]{yamlFile.getName()});
        if (result.getDataSources().isEmpty() && null != result.getDataSource()) {
            result.getDataSources().put(DEFAULT_DATASOURCE_NAME, result.getDataSource());
        }
        Preconditions.checkState((!result.getDataSources().isEmpty() ? 1 : 0) != 0, (String)"Data sources configuration in file `%s` is required.", (Object[])new Object[]{yamlFile.getName()});
        return Optional.of((Object)result);
    }

    private File[] findRuleConfigurationFiles(File path) {
        return path.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return RULE_CONFIG_FILE_PATTERN.matcher(pathname.getName()).matches();
            }
        });
    }
}

