/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.text.sctl.show;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.ShardingCTLParser;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.show.ShardingCTLShowStatement;

public final class ShardingCTLShowParser
implements ShardingCTLParser<ShardingCTLShowStatement> {
    private final String regex = "sctl:show\\s+(\\S*)";
    private final Matcher matcher;

    ShardingCTLShowParser(String sql) {
        this.matcher = Pattern.compile("sctl:show\\s+(\\S*)", 2).matcher(sql);
    }

    @Override
    public Optional<ShardingCTLShowStatement> doParse() {
        if (this.matcher.find()) {
            String value = this.matcher.group(1);
            Preconditions.checkNotNull((Object)value, (Object)"sctl show value cannot be null.");
            return Optional.of((Object)new ShardingCTLShowStatement(value));
        }
        return Optional.absent();
    }
}

