/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.executor;

import com.google.common.base.Joiner;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.api.hint.HintManager;
import org.apache.shardingsphere.core.merge.MergedResult;
import org.apache.shardingsphere.core.merge.dal.show.ShowShardingCTLMergedResult;
import org.apache.shardingsphere.core.rule.TableRule;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryHeader;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.command.HintShowTableStatusCommand;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.executor.AbstractHintQueryExecutor;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.result.HintShowTableStatusResult;

public final class HintShowTableStatusExecutor
extends AbstractHintQueryExecutor<HintShowTableStatusCommand> {
    private final BackendConnection backendConnection;

    @Override
    protected List<QueryHeader> createQueryHeaders() {
        ArrayList<QueryHeader> queryHeaders = new ArrayList<QueryHeader>(3);
        queryHeaders.add(new QueryHeader("", "", "table_name", "", 255, 1, 0, false, false, false, false));
        queryHeaders.add(new QueryHeader("", "", "database_sharding_values", "", 255, 1, 0, false, false, false, false));
        queryHeaders.add(new QueryHeader("", "", "table_sharding_values", "", 255, 1, 0, false, false, false, false));
        return queryHeaders;
    }

    @Override
    protected MergedResult createMergedResult() {
        HashMap<String, HintShowTableStatusResult> results = new HashMap<String, HintShowTableStatusResult>();
        for (String each : this.getLogicTableNames()) {
            if (HintManager.isDatabaseShardingOnly()) {
                this.fillShardingValues(results, each, HintManager.getDatabaseShardingValues(), Collections.emptyList());
                continue;
            }
            this.fillShardingValues(results, each, HintManager.getDatabaseShardingValues((String)each), HintManager.getTableShardingValues((String)each));
        }
        return this.convert2MergedResult(results.values());
    }

    private void fillShardingValues(Map<String, HintShowTableStatusResult> results, String logicTable, Collection<Comparable<?>> databaseShardingValues, Collection<Comparable<?>> tableShardingValues) {
        if (!results.containsKey(logicTable)) {
            results.put(logicTable, new HintShowTableStatusResult(logicTable));
        }
        for (Comparable<?> each : databaseShardingValues) {
            results.get(logicTable).getDatabaseShardingValues().add(each.toString());
        }
        for (Comparable<?> each : tableShardingValues) {
            results.get(logicTable).getTableShardingValues().add(each.toString());
        }
    }

    private Collection<String> getLogicTableNames() {
        LinkedList<String> result = new LinkedList<String>();
        Collection tableRules = this.backendConnection.getLogicSchema().getShardingRule().getTableRules();
        for (TableRule each : tableRules) {
            result.add(each.getLogicTable());
        }
        return result;
    }

    private MergedResult convert2MergedResult(Collection<HintShowTableStatusResult> hintShowTableStatusResults) {
        ArrayList<List<Object>> values = new ArrayList<List<Object>>(hintShowTableStatusResults.size());
        for (HintShowTableStatusResult each : hintShowTableStatusResults) {
            values.add(this.createRow(each));
        }
        return new ShowShardingCTLMergedResult(values);
    }

    private List<Object> createRow(HintShowTableStatusResult hintShowTableStatusResult) {
        ArrayList<Object> row = new ArrayList<Object>(3);
        row.add(hintShowTableStatusResult.getLogicTable());
        row.add(Joiner.on((String)",").join(hintShowTableStatusResult.getDatabaseShardingValues()));
        row.add(Joiner.on((String)",").join(hintShowTableStatusResult.getTableShardingValues()));
        return row;
    }

    @ConstructorProperties(value={"backendConnection"})
    public HintShowTableStatusExecutor(BackendConnection backendConnection) {
        this.backendConnection = backendConnection;
    }
}

