/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.executor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.shardingsphere.api.hint.HintManager;
import org.apache.shardingsphere.core.merge.MergedResult;
import org.apache.shardingsphere.core.merge.dal.show.ShowShardingCTLMergedResult;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryHeader;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.HintShardingType;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.command.HintShowStatusCommand;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.executor.AbstractHintQueryExecutor;

public final class HintShowStatusExecutor
extends AbstractHintQueryExecutor<HintShowStatusCommand> {
    @Override
    protected List<QueryHeader> createQueryHeaders() {
        ArrayList<QueryHeader> queryHeaders = new ArrayList<QueryHeader>(2);
        queryHeaders.add(new QueryHeader("", "", "master_only", "", 5, 1, 0, false, false, false, false));
        queryHeaders.add(new QueryHeader("", "", "sharding_type", "", 255, 1, 0, false, false, false, false));
        return queryHeaders;
    }

    @Override
    protected MergedResult createMergedResult() {
        HintShardingType shardingType = HintManager.isDatabaseShardingOnly() ? HintShardingType.DATABASES_ONLY : HintShardingType.DATABASES_TABLES;
        List<Object> row = this.createRow(HintManager.isMasterRouteOnly(), shardingType);
        return new ShowShardingCTLMergedResult(Collections.singletonList(row));
    }

    private List<Object> createRow(boolean masterOnly, HintShardingType shardingType) {
        ArrayList<Object> row = new ArrayList<Object>(2);
        row.add(String.valueOf(masterOnly).toLowerCase());
        row.add(String.valueOf((Object)shardingType).toLowerCase());
        return row;
    }
}

