/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.text.sctl;

import org.apache.shardingsphere.shardingproxy.backend.text.sctl.exception.InvalidShardingCTLFormatException;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.exception.ShardingCTLException;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.exception.UnsupportedShardingCTLTypeException;
import org.apache.shardingsphere.shardingproxy.error.SQLErrorCode;

public enum ShardingCTLErrorCode implements SQLErrorCode
{
    INVALID_FORMAT(11000, "S11000", "Invalid format for sharding ctl [%s]."),
    UNSUPPORTED_TYPE(11001, "S11001", "Could not support sctl type [%s].");

    private final int errorCode;
    private final String sqlState;
    private final String errorMessage;

    public static ShardingCTLErrorCode valueOf(ShardingCTLException exception) {
        if (exception instanceof InvalidShardingCTLFormatException) {
            return INVALID_FORMAT;
        }
        if (exception instanceof UnsupportedShardingCTLTypeException) {
            return UNSUPPORTED_TYPE;
        }
        throw new UnsupportedOperationException("Cannot find sharding CTL error code from exception: %s", exception);
    }

    private ShardingCTLErrorCode(int errorCode, String sqlState, String errorMessage) {
        this.errorCode = errorCode;
        this.sqlState = sqlState;
        this.errorMessage = errorMessage;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getSqlState() {
        return this.sqlState;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

