/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.text.admin;

import java.beans.ConstructorProperties;
import java.sql.SQLException;
import org.apache.shardingsphere.shardingproxy.backend.communication.DatabaseCommunicationEngine;
import org.apache.shardingsphere.shardingproxy.backend.communication.DatabaseCommunicationEngineFactory;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.shardingproxy.backend.response.BackendResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryData;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchemas;
import org.apache.shardingsphere.shardingproxy.backend.text.TextProtocolBackendHandler;

public final class UnicastBackendHandler
implements TextProtocolBackendHandler {
    private final DatabaseCommunicationEngineFactory databaseCommunicationEngineFactory = DatabaseCommunicationEngineFactory.getInstance();
    private final String sql;
    private final BackendConnection backendConnection;
    private DatabaseCommunicationEngine databaseCommunicationEngine;

    @Override
    public BackendResponse execute() {
        LogicSchema logicSchema = this.backendConnection.getLogicSchema();
        if (null == logicSchema) {
            logicSchema = LogicSchemas.getInstance().getLogicSchemas().values().iterator().next();
            this.backendConnection.setCurrentSchema(logicSchema.getName());
        }
        this.databaseCommunicationEngine = this.databaseCommunicationEngineFactory.newTextProtocolInstance(logicSchema, this.sql, this.backendConnection);
        return this.databaseCommunicationEngine.execute();
    }

    @Override
    public boolean next() throws SQLException {
        return this.databaseCommunicationEngine.next();
    }

    @Override
    public QueryData getQueryData() throws SQLException {
        return this.databaseCommunicationEngine.getQueryData();
    }

    @ConstructorProperties(value={"sql", "backendConnection"})
    public UnicastBackendHandler(String sql, BackendConnection backendConnection) {
        this.sql = sql;
        this.backendConnection = backendConnection;
    }
}

