/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.schema;

import com.google.common.base.Strings;
import com.google.common.eventbus.Subscribe;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shardingsphere.api.config.RuleConfiguration;
import org.apache.shardingsphere.core.database.DatabaseTypes;
import org.apache.shardingsphere.orchestration.internal.eventbus.ShardingOrchestrationEventBus;
import org.apache.shardingsphere.orchestration.internal.registry.config.event.SchemaAddedEvent;
import org.apache.shardingsphere.orchestration.internal.registry.config.event.SchemaDeletedEvent;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.recognizer.JDBCDriverURLRecognizerEngine;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchemaFactory;
import org.apache.shardingsphere.shardingproxy.config.yaml.YamlDataSourceParameter;
import org.apache.shardingsphere.shardingproxy.util.DataSourceConverter;
import org.apache.shardingsphere.spi.database.DatabaseType;

public final class LogicSchemas {
    private static final LogicSchemas INSTANCE = new LogicSchemas();
    private final Map<String, LogicSchema> logicSchemas = new ConcurrentHashMap<String, LogicSchema>();
    private DatabaseType databaseType;

    private LogicSchemas() {
        ShardingOrchestrationEventBus.getInstance().register((Object)this);
    }

    public static LogicSchemas getInstance() {
        return INSTANCE;
    }

    public void init(Map<String, Map<String, YamlDataSourceParameter>> schemaDataSources, Map<String, RuleConfiguration> schemaRules) throws SQLException {
        this.init(schemaRules.keySet(), schemaDataSources, schemaRules, false);
    }

    public void init(Collection<String> localSchemaNames, Map<String, Map<String, YamlDataSourceParameter>> schemaDataSources, Map<String, RuleConfiguration> schemaRules, boolean isUsingRegistry) throws SQLException {
        this.databaseType = DatabaseTypes.getActualDatabaseType((String)JDBCDriverURLRecognizerEngine.getJDBCDriverURLRecognizer(schemaDataSources.values().iterator().next().values().iterator().next().getUrl()).getDatabaseType());
        this.initSchemas(localSchemaNames, schemaDataSources, schemaRules, isUsingRegistry);
    }

    private void initSchemas(Collection<String> localSchemaNames, Map<String, Map<String, YamlDataSourceParameter>> schemaDataSources, Map<String, RuleConfiguration> schemaRules, boolean isUsingRegistry) throws SQLException {
        if (schemaRules.isEmpty()) {
            this.logicSchemas.put(schemaDataSources.keySet().iterator().next(), LogicSchemaFactory.newInstance(schemaDataSources.keySet().iterator().next(), schemaDataSources, null, isUsingRegistry));
        }
        for (Map.Entry<String, RuleConfiguration> entry : schemaRules.entrySet()) {
            if (!localSchemaNames.isEmpty() && !localSchemaNames.contains(entry.getKey())) continue;
            this.logicSchemas.put(entry.getKey(), LogicSchemaFactory.newInstance(entry.getKey(), schemaDataSources, entry.getValue(), isUsingRegistry));
        }
    }

    public boolean schemaExists(String schema) {
        return this.logicSchemas.keySet().contains(schema);
    }

    public LogicSchema getLogicSchema(String schemaName) {
        return Strings.isNullOrEmpty((String)schemaName) ? null : this.logicSchemas.get(schemaName);
    }

    public List<String> getSchemaNames() {
        return new LinkedList<String>(this.logicSchemas.keySet());
    }

    @Subscribe
    public synchronized void renew(SchemaAddedEvent schemaAddedEvent) throws SQLException {
        this.logicSchemas.put(schemaAddedEvent.getShardingSchemaName(), LogicSchemaFactory.newInstance(schemaAddedEvent.getShardingSchemaName(), Collections.singletonMap(schemaAddedEvent.getShardingSchemaName(), DataSourceConverter.getDataSourceParameterMap((Map)schemaAddedEvent.getDataSourceConfigurations())), schemaAddedEvent.getRuleConfiguration(), true));
    }

    @Subscribe
    public synchronized void renew(SchemaDeletedEvent schemaDeletedEvent) {
        this.logicSchemas.remove(schemaDeletedEvent.getShardingSchemaName());
    }

    public Map<String, LogicSchema> getLogicSchemas() {
        return this.logicSchemas;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }
}

