/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.wrapper;

import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.shardingsphere.core.SimpleQueryShardingEngine;
import org.apache.shardingsphere.core.constant.properties.ShardingPropertiesConstant;
import org.apache.shardingsphere.core.metadata.table.TableMetas;
import org.apache.shardingsphere.core.parse.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.preprocessor.SQLStatementContextFactory;
import org.apache.shardingsphere.core.preprocessor.statement.SQLStatementContext;
import org.apache.shardingsphere.core.preprocessor.statement.impl.CommonSQLStatementContext;
import org.apache.shardingsphere.core.rewrite.context.SQLRewriteContext;
import org.apache.shardingsphere.core.rewrite.engine.impl.DefaultSQLRewriteEngine;
import org.apache.shardingsphere.core.rewrite.feature.encrypt.context.EncryptSQLRewriteContextDecorator;
import org.apache.shardingsphere.core.route.RouteUnit;
import org.apache.shardingsphere.core.route.SQLRouteResult;
import org.apache.shardingsphere.core.route.SQLUnit;
import org.apache.shardingsphere.core.route.router.masterslave.MasterSlaveRouter;
import org.apache.shardingsphere.core.route.router.sharding.condition.ShardingConditions;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.wrapper.JDBCExecutorWrapper;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.impl.EncryptSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.impl.MasterSlaveSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.impl.ShardingSchema;
import org.apache.shardingsphere.shardingproxy.context.ShardingProxyContext;

public final class StatementExecutorWrapper
implements JDBCExecutorWrapper {
    private static final ShardingProxyContext SHARDING_PROXY_CONTEXT = ShardingProxyContext.getInstance();
    private final LogicSchema logicSchema;

    @Override
    public SQLRouteResult route(String sql) {
        if (this.logicSchema instanceof ShardingSchema) {
            return this.doShardingRoute(sql);
        }
        if (this.logicSchema instanceof MasterSlaveSchema) {
            return this.doMasterSlaveRoute(sql);
        }
        if (this.logicSchema instanceof EncryptSchema) {
            return this.doEncryptRoute(sql);
        }
        return this.doTransparentRoute(sql);
    }

    private SQLRouteResult doShardingRoute(String sql) {
        SimpleQueryShardingEngine shardingEngine = new SimpleQueryShardingEngine(this.logicSchema.getShardingRule(), ShardingProxyContext.getInstance().getShardingProperties(), this.logicSchema.getMetaData(), this.logicSchema.getParseEngine());
        return shardingEngine.shard(sql, Collections.emptyList());
    }

    private SQLRouteResult doMasterSlaveRoute(String sql) {
        SQLStatement sqlStatement = this.logicSchema.getParseEngine().parse(sql, false);
        CommonSQLStatementContext sqlStatementContext = new CommonSQLStatementContext(sqlStatement);
        SQLRewriteContext sqlRewriteContext = new SQLRewriteContext(this.logicSchema.getMetaData().getTables(), (SQLStatementContext)sqlStatementContext, sql, Collections.emptyList());
        sqlRewriteContext.generateSQLTokens();
        String rewriteSQL = new DefaultSQLRewriteEngine().rewrite(sqlRewriteContext).getSql();
        SQLRouteResult result = new SQLRouteResult((SQLStatementContext)sqlStatementContext, new ShardingConditions(Collections.emptyList()));
        for (String each : new MasterSlaveRouter(((MasterSlaveSchema)this.logicSchema).getMasterSlaveRule(), this.logicSchema.getParseEngine(), ((Boolean)SHARDING_PROXY_CONTEXT.getShardingProperties().getValue(ShardingPropertiesConstant.SQL_SHOW)).booleanValue()).route(rewriteSQL, false)) {
            result.getRouteUnits().add(new RouteUnit(each, new SQLUnit(rewriteSQL, Collections.emptyList())));
        }
        return result;
    }

    private SQLRouteResult doEncryptRoute(String sql) {
        EncryptSchema encryptSchema = (EncryptSchema)this.logicSchema;
        SQLStatement sqlStatement = encryptSchema.getParseEngine().parse(sql, false);
        SQLStatementContext sqlStatementContext = SQLStatementContextFactory.newInstance((TableMetas)this.logicSchema.getMetaData().getTables(), (String)sql, new LinkedList(), (SQLStatement)sqlStatement);
        SQLRewriteContext sqlRewriteContext = new SQLRewriteContext(this.logicSchema.getMetaData().getTables(), sqlStatementContext, sql, Collections.emptyList());
        boolean isQueryWithCipherColumn = (Boolean)ShardingProxyContext.getInstance().getShardingProperties().getValue(ShardingPropertiesConstant.QUERY_WITH_CIPHER_COLUMN);
        new EncryptSQLRewriteContextDecorator(encryptSchema.getEncryptRule(), isQueryWithCipherColumn).decorate(sqlRewriteContext);
        sqlRewriteContext.generateSQLTokens();
        SQLRouteResult result = new SQLRouteResult(sqlStatementContext, new ShardingConditions(Collections.emptyList()));
        result.getRouteUnits().add(new RouteUnit(this.logicSchema.getDataSources().keySet().iterator().next(), new SQLUnit(new DefaultSQLRewriteEngine().rewrite(sqlRewriteContext).getSql(), Collections.emptyList())));
        return result;
    }

    private SQLRouteResult doTransparentRoute(String sql) {
        SQLStatement sqlStatement = this.logicSchema.getParseEngine().parse(sql, false);
        SQLRouteResult result = new SQLRouteResult((SQLStatementContext)new CommonSQLStatementContext(sqlStatement), new ShardingConditions(Collections.emptyList()));
        result.getRouteUnits().add(new RouteUnit(this.logicSchema.getDataSources().keySet().iterator().next(), new SQLUnit(sql, Collections.emptyList())));
        return result;
    }

    @Override
    public Statement createStatement(Connection connection, SQLUnit sqlUnit, boolean isReturnGeneratedKeys) throws SQLException {
        return connection.createStatement();
    }

    @Override
    public boolean executeSQL(Statement statement, String sql, boolean isReturnGeneratedKeys) throws SQLException {
        return statement.execute(sql, isReturnGeneratedKeys ? 1 : 2);
    }

    @ConstructorProperties(value={"logicSchema"})
    public StatementExecutorWrapper(LogicSchema logicSchema) {
        this.logicSchema = logicSchema;
    }
}

