/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.spring.namespace.parser;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.shardingsphere.shardingjdbc.spring.datasource.SpringMasterSlaveDataSource;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public final class MasterSlaveDataSourceBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(SpringMasterSlaveDataSource.class);
        factory.addConstructorArgValue(this.parseDataSources(element));
        factory.addConstructorArgValue((Object)this.parseId(element));
        factory.addConstructorArgValue((Object)this.parseMasterDataSourceRef(element));
        factory.addConstructorArgValue(this.parseSlaveDataSourcesRef(element));
        String loadBalanceAlgorithmRefAttributeRef = this.parseLoadBalanceAlgorithmRefAttributeRef(element);
        if (!Strings.isNullOrEmpty((String)loadBalanceAlgorithmRefAttributeRef)) {
            factory.addConstructorArgReference(loadBalanceAlgorithmRefAttributeRef);
        } else {
            factory.addConstructorArgValue(null);
        }
        factory.addConstructorArgValue((Object)this.parseProperties(element, parserContext));
        return factory.getBeanDefinition();
    }

    private Map<String, RuntimeBeanReference> parseDataSources(Element element) {
        List slaveDataSources = Splitter.on((String)",").trimResults().splitToList((CharSequence)element.getAttribute("slave-data-source-names"));
        ManagedMap result = new ManagedMap(slaveDataSources.size());
        for (String each : slaveDataSources) {
            result.put(each, new RuntimeBeanReference(each));
        }
        String masterDataSourceName = this.parseMasterDataSourceRef(element);
        result.put(masterDataSourceName, new RuntimeBeanReference(masterDataSourceName));
        return result;
    }

    private String parseId(Element element) {
        return element.getAttribute("id");
    }

    private String parseMasterDataSourceRef(Element element) {
        return element.getAttribute("master-data-source-name");
    }

    private Collection<String> parseSlaveDataSourcesRef(Element element) {
        List slaveDataSources = Splitter.on((String)",").trimResults().splitToList((CharSequence)element.getAttribute("slave-data-source-names"));
        ManagedList result = new ManagedList(slaveDataSources.size());
        result.addAll(slaveDataSources);
        return result;
    }

    private String parseLoadBalanceAlgorithmRefAttributeRef(Element element) {
        return element.getAttribute("strategy-ref");
    }

    private Properties parseProperties(Element element, ParserContext parserContext) {
        Element propsElement = DomUtils.getChildElementByTagName((Element)element, (String)"props");
        return null == propsElement ? new Properties() : parserContext.getDelegate().parsePropsElement(propsElement);
    }
}

