/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.orchestration.api.yaml;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.core.rule.MasterSlaveRule;
import org.apache.shardingsphere.core.yaml.config.masterslave.YamlMasterSlaveRuleConfiguration;
import org.apache.shardingsphere.core.yaml.swapper.MasterSlaveRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.orchestration.center.config.OrchestrationConfiguration;
import org.apache.shardingsphere.orchestration.center.yaml.config.YamlCenterRepositoryConfiguration;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.datasource.MasterSlaveDataSource;
import org.apache.shardingsphere.shardingjdbc.orchestration.internal.datasource.OrchestrationMasterSlaveDataSource;
import org.apache.shardingsphere.shardingjdbc.orchestration.internal.util.YamlCenterRepositoryConfigurationSwapperUtil;
import org.apache.shardingsphere.shardingjdbc.orchestration.internal.yaml.YamlOrchestrationMasterSlaveRuleConfiguration;
import org.apache.shardingsphere.underlying.common.yaml.engine.YamlEngine;

public final class YamlOrchestrationMasterSlaveDataSourceFactory {
    private static final MasterSlaveRuleConfigurationYamlSwapper MASTER_SLAVE_RULE_SWAPPER = new MasterSlaveRuleConfigurationYamlSwapper();

    public static DataSource createDataSource(File yamlFile) throws SQLException, IOException {
        YamlOrchestrationMasterSlaveRuleConfiguration config = YamlOrchestrationMasterSlaveDataSourceFactory.unmarshal(yamlFile);
        return YamlOrchestrationMasterSlaveDataSourceFactory.createDataSource(config.getDataSources(), config.getMasterSlaveRule(), config.getProps(), config.getOrchestration());
    }

    public static DataSource createDataSource(Map<String, DataSource> dataSourceMap, File yamlFile) throws SQLException, IOException {
        YamlOrchestrationMasterSlaveRuleConfiguration config = YamlOrchestrationMasterSlaveDataSourceFactory.unmarshal(yamlFile);
        return YamlOrchestrationMasterSlaveDataSourceFactory.createDataSource(dataSourceMap, config.getMasterSlaveRule(), config.getProps(), config.getOrchestration());
    }

    public static DataSource createDataSource(byte[] yamlBytes) throws SQLException, IOException {
        YamlOrchestrationMasterSlaveRuleConfiguration config = YamlOrchestrationMasterSlaveDataSourceFactory.unmarshal(yamlBytes);
        return YamlOrchestrationMasterSlaveDataSourceFactory.createDataSource(config.getDataSources(), config.getMasterSlaveRule(), config.getProps(), config.getOrchestration());
    }

    public static DataSource createDataSource(Map<String, DataSource> dataSourceMap, byte[] yamlBytes) throws SQLException, IOException {
        YamlOrchestrationMasterSlaveRuleConfiguration config = YamlOrchestrationMasterSlaveDataSourceFactory.unmarshal(yamlBytes);
        return YamlOrchestrationMasterSlaveDataSourceFactory.createDataSource(dataSourceMap, config.getMasterSlaveRule(), config.getProps(), config.getOrchestration());
    }

    private static DataSource createDataSource(Map<String, DataSource> dataSourceMap, YamlMasterSlaveRuleConfiguration yamlMasterSlaveRuleConfiguration, Properties props, Map<String, YamlCenterRepositoryConfiguration> yamlInstanceConfigurationMap) throws SQLException {
        if (null == yamlMasterSlaveRuleConfiguration) {
            return new OrchestrationMasterSlaveDataSource(new OrchestrationConfiguration(YamlCenterRepositoryConfigurationSwapperUtil.marshal(yamlInstanceConfigurationMap)));
        }
        MasterSlaveDataSource masterSlaveDataSource = new MasterSlaveDataSource(dataSourceMap, new MasterSlaveRule(MASTER_SLAVE_RULE_SWAPPER.swap(yamlMasterSlaveRuleConfiguration)), props);
        return new OrchestrationMasterSlaveDataSource(masterSlaveDataSource, new OrchestrationConfiguration(YamlCenterRepositoryConfigurationSwapperUtil.marshal(yamlInstanceConfigurationMap)));
    }

    private static YamlOrchestrationMasterSlaveRuleConfiguration unmarshal(File yamlFile) throws IOException {
        return (YamlOrchestrationMasterSlaveRuleConfiguration)YamlEngine.unmarshal((File)yamlFile, YamlOrchestrationMasterSlaveRuleConfiguration.class);
    }

    private static YamlOrchestrationMasterSlaveRuleConfiguration unmarshal(byte[] yamlBytes) throws IOException {
        return (YamlOrchestrationMasterSlaveRuleConfiguration)YamlEngine.unmarshal((byte[])yamlBytes, YamlOrchestrationMasterSlaveRuleConfiguration.class);
    }

    @Generated
    private YamlOrchestrationMasterSlaveDataSourceFactory() {
    }
}

