/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.orchestration.api.yaml;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.yaml.config.YamlEncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.yaml.swapper.EncryptRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.orchestration.center.config.OrchestrationConfiguration;
import org.apache.shardingsphere.orchestration.center.yaml.config.YamlCenterRepositoryConfiguration;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.datasource.EncryptDataSource;
import org.apache.shardingsphere.shardingjdbc.orchestration.internal.datasource.OrchestrationEncryptDataSource;
import org.apache.shardingsphere.shardingjdbc.orchestration.internal.util.YamlCenterRepositoryConfigurationSwapperUtil;
import org.apache.shardingsphere.shardingjdbc.orchestration.internal.yaml.YamlOrchestrationEncryptRuleConfiguration;
import org.apache.shardingsphere.underlying.common.yaml.engine.YamlEngine;

public final class YamlOrchestrationEncryptDataSourceFactory {
    private static final EncryptRuleConfigurationYamlSwapper ENCRYPT_RULE_SWAPPER = new EncryptRuleConfigurationYamlSwapper();

    public static DataSource createDataSource(File yamlFile) throws IOException, SQLException {
        YamlOrchestrationEncryptRuleConfiguration config = YamlOrchestrationEncryptDataSourceFactory.unmarshal(yamlFile);
        return YamlOrchestrationEncryptDataSourceFactory.createDataSource(config.getDataSource(), config.getEncryptRule(), config.getOrchestration(), config.getProps());
    }

    public static DataSource createDataSource(DataSource dataSource, File yamlFile) throws IOException, SQLException {
        YamlOrchestrationEncryptRuleConfiguration config = YamlOrchestrationEncryptDataSourceFactory.unmarshal(yamlFile);
        return YamlOrchestrationEncryptDataSourceFactory.createDataSource(dataSource, config.getEncryptRule(), config.getOrchestration(), config.getProps());
    }

    public static DataSource createDataSource(byte[] yamlBytes) throws IOException, SQLException {
        YamlOrchestrationEncryptRuleConfiguration config = YamlOrchestrationEncryptDataSourceFactory.unmarshal(yamlBytes);
        return YamlOrchestrationEncryptDataSourceFactory.createDataSource(config.getDataSource(), config.getEncryptRule(), config.getOrchestration(), config.getProps());
    }

    public static DataSource createDataSource(DataSource dataSource, byte[] yamlBytes) throws IOException, SQLException {
        YamlOrchestrationEncryptRuleConfiguration config = YamlOrchestrationEncryptDataSourceFactory.unmarshal(yamlBytes);
        return YamlOrchestrationEncryptDataSourceFactory.createDataSource(dataSource, config.getEncryptRule(), config.getOrchestration(), config.getProps());
    }

    private static DataSource createDataSource(DataSource dataSource, YamlEncryptRuleConfiguration yamlEncryptRuleConfiguration, Map<String, YamlCenterRepositoryConfiguration> yamlInstanceConfigurationMap, Properties properties) throws SQLException {
        if (null == yamlEncryptRuleConfiguration) {
            return new OrchestrationEncryptDataSource(new OrchestrationConfiguration(YamlCenterRepositoryConfigurationSwapperUtil.marshal(yamlInstanceConfigurationMap)));
        }
        EncryptDataSource encryptDataSource = new EncryptDataSource(dataSource, new EncryptRule(ENCRYPT_RULE_SWAPPER.swap(yamlEncryptRuleConfiguration)), properties);
        return new OrchestrationEncryptDataSource(encryptDataSource, new OrchestrationConfiguration(YamlCenterRepositoryConfigurationSwapperUtil.marshal(yamlInstanceConfigurationMap)));
    }

    private static YamlOrchestrationEncryptRuleConfiguration unmarshal(File yamlFile) throws IOException {
        return (YamlOrchestrationEncryptRuleConfiguration)YamlEngine.unmarshal((File)yamlFile, YamlOrchestrationEncryptRuleConfiguration.class);
    }

    private static YamlOrchestrationEncryptRuleConfiguration unmarshal(byte[] yamlBytes) throws IOException {
        return (YamlOrchestrationEncryptRuleConfiguration)YamlEngine.unmarshal((byte[])yamlBytes, YamlOrchestrationEncryptRuleConfiguration.class);
    }

    @Generated
    private YamlOrchestrationEncryptDataSourceFactory() {
    }
}

