/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.orchestration.api;

import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.shardingsphere.encrypt.api.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.orchestration.center.config.OrchestrationConfiguration;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.datasource.EncryptDataSource;
import org.apache.shardingsphere.shardingjdbc.orchestration.internal.datasource.OrchestrationEncryptDataSource;

public final class OrchestrationEncryptDataSourceFactory {
    public static DataSource createDataSource(DataSource dataSource, EncryptRuleConfiguration encryptRuleConfig, Properties props, OrchestrationConfiguration orchestrationConfig) throws SQLException {
        if (null == encryptRuleConfig || encryptRuleConfig.getEncryptors().isEmpty()) {
            return OrchestrationEncryptDataSourceFactory.createDataSource(orchestrationConfig);
        }
        return new OrchestrationEncryptDataSource(new EncryptDataSource(dataSource, new EncryptRule(encryptRuleConfig), props), orchestrationConfig);
    }

    public static DataSource createDataSource(OrchestrationConfiguration orchestrationConfig) throws SQLException {
        return new OrchestrationEncryptDataSource(orchestrationConfig);
    }
}

