/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.file;

import edu.emory.mathcs.backport.java.util.concurrent.locks.Lock;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jbi.JBIException;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.endpoints.PollingEndpoint;
import org.apache.servicemix.components.util.DefaultFileMarshaler;
import org.apache.servicemix.components.util.FileMarshaler;
import org.apache.servicemix.file.FileEndpointType;
import org.apache.servicemix.locks.LockManager;
import org.apache.servicemix.locks.impl.SimpleLockManager;

public class FilePollerEndpoint
extends PollingEndpoint
implements FileEndpointType {
    private File file;
    private FileFilter filter;
    private boolean deleteFile = true;
    private boolean recursive = true;
    private boolean autoCreateDirectory = true;
    private FileMarshaler marshaler = new DefaultFileMarshaler();
    private LockManager lockManager;

    public FilePollerEndpoint() {
    }

    public FilePollerEndpoint(ServiceUnit serviceUnit, QName service, String endpoint) {
        super(serviceUnit, service, endpoint);
    }

    public FilePollerEndpoint(DefaultComponent component, ServiceEndpoint endpoint) {
        super(component, endpoint);
    }

    public void poll() throws Exception {
        this.pollFileOrDirectory(this.file);
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.file == null) {
            throw new DeploymentException("You must specify a file property");
        }
        if (this.isAutoCreateDirectory() && !this.file.exists()) {
            this.file.mkdirs();
        }
        if (this.lockManager == null) {
            this.lockManager = this.createLockManager();
        }
    }

    protected LockManager createLockManager() {
        return new SimpleLockManager();
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public void setLockManager(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    public FileFilter getFilter() {
        return this.filter;
    }

    public void setFilter(FileFilter filter) {
        this.filter = filter;
    }

    public boolean isDeleteFile() {
        return this.deleteFile;
    }

    public void setDeleteFile(boolean deleteFile) {
        this.deleteFile = deleteFile;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public boolean isAutoCreateDirectory() {
        return this.autoCreateDirectory;
    }

    public void setAutoCreateDirectory(boolean autoCreateDirectory) {
        this.autoCreateDirectory = autoCreateDirectory;
    }

    public FileMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(FileMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    protected void pollFileOrDirectory(File fileOrDirectory) {
        this.pollFileOrDirectory(fileOrDirectory, true);
    }

    protected void pollFileOrDirectory(File fileOrDirectory, boolean processDir) {
        if (!fileOrDirectory.isDirectory()) {
            this.pollFile(fileOrDirectory);
        } else if (processDir) {
            this.logger.debug((Object)("Polling directory " + fileOrDirectory));
            File[] files = fileOrDirectory.listFiles(this.getFilter());
            for (int i = 0; i < files.length; ++i) {
                this.pollFileOrDirectory(files[i], this.isRecursive());
            }
        } else {
            this.logger.debug((Object)("Skipping directory " + fileOrDirectory));
        }
    }

    protected void pollFile(final File aFile) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Scheduling file " + aFile + " for processing"));
        }
        this.getExecutor().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String uri = FilePollerEndpoint.this.file.toURI().relativize(aFile.toURI()).toString();
                Lock lock = FilePollerEndpoint.this.lockManager.getLock(uri);
                if (lock.tryLock()) {
                    boolean unlock = true;
                    try {
                        unlock = FilePollerEndpoint.this.processFileAndDelete(aFile);
                    }
                    finally {
                        if (unlock) {
                            lock.unlock();
                        }
                    }
                } else if (FilePollerEndpoint.this.logger.isDebugEnabled()) {
                    FilePollerEndpoint.this.logger.debug((Object)("Unable to acquire lock on " + aFile));
                }
            }
        });
    }

    protected boolean processFileAndDelete(File aFile) {
        boolean unlock = true;
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Processing file " + aFile));
            }
            if (aFile.exists()) {
                this.processFile(aFile);
                unlock = false;
                if (this.isDeleteFile()) {
                    if (!aFile.delete()) {
                        throw new IOException("Could not delete file " + aFile);
                    }
                    unlock = true;
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Failed to process file: " + aFile + ". Reason: " + e), (Throwable)e);
        }
        return unlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFile(File aFile) throws Exception {
        InputStream in = null;
        try {
            String name = aFile.getCanonicalPath();
            in = new BufferedInputStream(new FileInputStream(aFile));
            InOnly exchange = this.getExchangeFactory().createInOnlyExchange();
            this.configureExchangeTarget((MessageExchange)exchange);
            NormalizedMessage message = exchange.createMessage();
            exchange.setInMessage(message);
            this.marshaler.readMessage((MessageExchange)exchange, message, in, name);
            this.sendSync((MessageExchange)exchange);
            if (exchange.getStatus() == ExchangeStatus.ERROR) {
                Throwable e = exchange.getError();
                if (e == null) {
                    e = new JBIException("Unkown error");
                }
                throw e;
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public String getLocationURI() {
        return this.file.toURI().toString();
    }

    public void process(MessageExchange exchange) throws Exception {
    }
}

