/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.file;

import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.jbi.servicedesc.ServiceEndpoint;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.file.FileEndpointType;
import org.apache.servicemix.file.FilePollerEndpoint;
import org.apache.servicemix.file.FileSenderEndpoint;
import org.apache.servicemix.jbi.util.IntrospectionSupport;
import org.apache.servicemix.jbi.util.URISupport;

public class FileComponent
extends DefaultComponent {
    private FileEndpointType[] endpoints;

    public FileEndpointType[] getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(FileEndpointType[] endpoints) {
        this.endpoints = endpoints;
    }

    protected List getConfiguredEndpoints() {
        return FileComponent.asList((Object[])this.getEndpoints());
    }

    protected Class[] getEndpointClasses() {
        return new Class[]{FilePollerEndpoint.class, FileSenderEndpoint.class};
    }

    protected Endpoint getResolvedEPR(ServiceEndpoint ep) throws Exception {
        FileSenderEndpoint fileEp = new FileSenderEndpoint(this, ep);
        URI uri = new URI(ep.getEndpointName());
        String file = null;
        String host = uri.getHost();
        String path = uri.getPath();
        file = host != null ? (path != null ? host + File.separator + path : host) : (path != null ? path : uri.getSchemeSpecificPart());
        Map map = URISupport.parseQuery((String)uri.getQuery());
        IntrospectionSupport.setProperties((Object)fileEp, (Map)map);
        if (file == null) {
            throw new IllegalArgumentException("No file defined for URL: " + uri);
        }
        fileEp.setDirectory(new File(file));
        fileEp.activate();
        return fileEp;
    }
}

