/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.config;

import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import io.vertx.core.http.HttpVersion;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.servicecomb.deployment.Deployment;
import org.apache.servicecomb.foundation.common.net.IpPort;
import org.apache.servicecomb.foundation.common.net.NetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceRegistryConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceRegistryConfig.class);
    public static final ServiceRegistryConfig INSTANCE = new ServiceRegistryConfig();
    private static final int DEFAULT_TIMEOUT_IN_MS = 30000;
    private static final int DEFAULT_TIMEOUT_IN_SECONDS = 30;
    private static final int DEFAULT_REQUEST_TIMEOUT_IN_MS = 30000;
    private static final int DEFAULT_REQUEST_HEARTBEAT_TIMEOUT_IN_MS = 3000;
    private static final int DEFAULT_CHECK_INTERVAL_IN_S = 30;
    private static final int DEFAULT_CHECK_TIMES = 3;
    public static final String AUTH_ENABLED = "servicecomb.auth.enabled";
    public static final String TENANT_ACCESS_KEY = "servicecomb.auth.accessKey";
    public static final String TENANT_SECRET_KEY = "servicecomb.auth.secretKey";
    public static final String REGISTRY_API_VERSION = "servicecomb.service.registry.api.version";
    public static final String TENANT_NAME = "servicecomb.config.client.tenantName";
    public static final String DOMAIN_NAME = "servicecomb.config.client.domainName";
    public static final String NO_TENANT = "default";
    public static final String NO_DOMAIN = "default";
    public static final String MICROSERVICE_VERSION_FACTORY = "servicecomb.microserviceVersionFactory";
    private boolean ssl = true;
    public static final String PROXY_PRE_NAME = "servicecomb.proxy.";
    public static final String PROXY_ENABLE = "servicecomb.proxy.enable";
    public static final String PROXY_HOST = "servicecomb.proxy.host";
    public static final String PROXY_PORT = "servicecomb.proxy.port";
    public static final String PROXY_USERNAME = "servicecomb.proxy.username";
    public static final String PROXY_PASSWD = "servicecomb.proxy.passwd";
    public static final String SSL_KEY = "sc.consumer";
    public static final String PROXY_KEY = "sc.consumer";
    public static final String VERTICLE_INSTANCES = "servicecomb.service.registry.client.instances";
    public static final String EVENT_LOOP_POOL_SIZE = "servicecomb.service.registry.client.eventLoopPoolSize";
    public static final String WORKER_POOL_SIZE = "servicecomb.service.registry.client.workerPoolSize";
    public static final String WORKER_POOL_NAME = "registry-vert.x-worker-thread";

    private ServiceRegistryConfig() {
    }

    public String getMicroserviceVersionFactory() {
        return DynamicPropertyFactory.getInstance().getStringProperty(MICROSERVICE_VERSION_FACTORY, null).get();
    }

    public String getStaticMicroserviceVersionFactory() {
        return "org.apache.servicecomb.core.definition.StaticMicroserviceVersionMetaFactory";
    }

    public HttpVersion getHttpVersion() {
        DynamicStringProperty property = DynamicPropertyFactory.getInstance().getStringProperty("servicecomb.service.registry.client.httpVersion", "HTTP_1_1");
        return HttpVersion.valueOf((String)property.get());
    }

    public int getInstances() {
        DynamicIntProperty property = DynamicPropertyFactory.getInstance().getIntProperty(VERTICLE_INSTANCES, 1);
        int deployInstances = property.get();
        if (deployInstances <= 0) {
            int nAvailableProcessors = Runtime.getRuntime().availableProcessors();
            LOGGER.warn("The property `{}` must be positive integer, fallback to use number of available processors: {}", (Object)VERTICLE_INSTANCES, (Object)nAvailableProcessors);
            return nAvailableProcessors;
        }
        return deployInstances;
    }

    public boolean isSsl() {
        this.getIpPort();
        return this.ssl;
    }

    public ArrayList<IpPort> getIpPort() {
        List uriList = Deployment.getSystemBootStrapInfo((String)"ServiceCenter").getAccessURL();
        ArrayList<IpPort> ipPortList = new ArrayList<IpPort>();
        uriList.forEach(anUriList -> {
            try {
                URI uri = new URI(anUriList.trim());
                this.ssl = "https".equals(uri.getScheme());
                ipPortList.add(NetUtils.parseIpPort((URI)uri));
            }
            catch (Exception e) {
                LOGGER.error("servicecomb.service.registry.address invalid : {}", anUriList, (Object)e);
            }
        });
        return ipPortList;
    }

    public String getTransport() {
        return "rest";
    }

    public int getConnectionTimeout() {
        DynamicIntProperty property = DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.service.registry.client.timeout.connection", 30000);
        int timeout = property.get();
        return timeout < 0 ? 30000 : timeout;
    }

    public int getIdleConnectionTimeout() {
        DynamicIntProperty property = DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.service.registry.client.timeout.idle", 60);
        int timeout = property.get();
        return timeout < 1 ? 60 : timeout;
    }

    public int getIdleWatchTimeout() {
        DynamicIntProperty property = DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.service.registry.client.timeout.watch", 60);
        int timeout = property.get();
        return timeout < 1 ? 60 : timeout;
    }

    public int getRequestTimeout() {
        DynamicIntProperty property = DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.service.registry.client.timeout.request", 30000);
        int timeout = property.get();
        return timeout < 1 ? 30000 : timeout;
    }

    public int getHeartBeatRequestTimeout() {
        DynamicIntProperty property = DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.service.registry.client.timeout.heartbeat", 3000);
        int timeout = property.get();
        return timeout < 1 ? 3000 : timeout;
    }

    public int getHeartbeatInterval() {
        DynamicIntProperty property = DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.service.registry.instance.healthCheck.interval", 30);
        int interval = property.get();
        return interval < 0 ? 30 : interval;
    }

    public int getInstancePullInterval() {
        DynamicIntProperty property = DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.service.registry.instance.pull.interval", 30);
        int interval = property.get();
        return interval < 0 ? 30 : interval;
    }

    public boolean isRegistryAutoDiscovery() {
        DynamicBooleanProperty property = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.service.registry.autodiscovery", false);
        return property.get();
    }

    public int getResendHeartBeatTimes() {
        DynamicIntProperty property = DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.service.registry.instance.healthCheck.times", 3);
        int times = property.get();
        return times < 0 ? 3 : times;
    }

    public boolean isEmptyInstanceProtectionEnabled() {
        DynamicBooleanProperty property = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.service.registry.instance.empty.protection", true);
        return property.get();
    }

    public boolean isAlwaysOverrideSchema() {
        DynamicBooleanProperty property = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.service.registry.instance.alwaysOverrideSchema", false);
        return property.get();
    }

    public boolean isIgnoreSwaggerDifference() {
        DynamicBooleanProperty property = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.service.registry.instance.ignoreSwaggerDifference", false);
        return property.get();
    }

    public boolean isPreferIpAddress() {
        DynamicBooleanProperty property = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.service.registry.instance.preferIpAddress", false);
        return property.get();
    }

    public boolean isWatch() {
        DynamicBooleanProperty property = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.service.registry.instance.watch", true);
        return property.get();
    }

    public boolean isClientAuthEnabled() {
        String isAuthEnabled = this.getProperty("false", AUTH_ENABLED);
        return Boolean.parseBoolean(isAuthEnabled);
    }

    public String getRegistryApiVersion() {
        return this.getProperty("v4", REGISTRY_API_VERSION);
    }

    public String getTenantName() {
        return this.getProperty("default", TENANT_NAME);
    }

    public String getDomainName() {
        return this.getProperty("default", DOMAIN_NAME);
    }

    public String getAccessKey() {
        String tenantName = this.getProperty(null, TENANT_ACCESS_KEY);
        return tenantName;
    }

    public String getSecretKey() {
        String tenantName = this.getProperty(null, TENANT_SECRET_KEY);
        return tenantName;
    }

    public Boolean isProxyEnable() {
        String enable = this.getProperty("false", PROXY_ENABLE);
        return Boolean.parseBoolean(enable);
    }

    public String getProxyHost() {
        String host = this.getProperty("127.0.0.1", PROXY_HOST);
        return host;
    }

    public int getProxyPort() {
        String port = this.getProperty("8080", PROXY_PORT);
        return Integer.parseInt(port);
    }

    public String getProxyUsername() {
        String username = this.getProperty(null, PROXY_USERNAME);
        return username;
    }

    public String getProxyPasswd() {
        String passwd = this.getProperty(null, PROXY_PASSWD);
        return passwd;
    }

    private String getProperty(String defaultValue, String ... keys) {
        String property = null;
        for (String key : keys) {
            property = DynamicPropertyFactory.getInstance().getStringProperty(key, null).get();
            if (property != null) break;
        }
        if (property != null) {
            return property;
        }
        return defaultValue;
    }
}

