/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.springmvc.reference;

import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.servicecomb.common.rest.codec.RestCodec;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.common.rest.locator.OperationLocator;
import org.apache.servicecomb.common.rest.locator.ServicePathManager;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.invocation.InvocationFactory;
import org.apache.servicecomb.core.provider.consumer.InvokerUtils;
import org.apache.servicecomb.core.provider.consumer.ReferenceConfig;
import org.apache.servicecomb.provider.springmvc.reference.CommonToHttpServletRequest;
import org.apache.servicecomb.provider.springmvc.reference.CseClientHttpResponse;
import org.apache.servicecomb.provider.springmvc.reference.RequestMeta;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.context.InvocationContext;
import org.apache.servicecomb.swagger.invocation.exception.ExceptionFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;

public class CseClientHttpRequest
implements ClientHttpRequest {
    private URI uri;
    private String path;
    private HttpMethod method;
    private HttpHeaders httpHeaders = new HttpHeaders();
    private InvocationContext context;
    private Object requestBody;
    private Map<String, List<String>> queryParams;
    private RequestMeta requestMeta;

    public CseClientHttpRequest() {
    }

    public CseClientHttpRequest(URI uri, HttpMethod method) {
        this.uri = uri;
        this.method = method;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    protected RequestMeta getRequestMeta() {
        return this.requestMeta;
    }

    protected void setRequestMeta(RequestMeta requestMeta) {
        this.requestMeta = requestMeta;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    protected void setQueryParams(Map<String, List<String>> queryParams) {
        this.queryParams = queryParams;
    }

    public InvocationContext getContext() {
        return this.context;
    }

    public void setContext(InvocationContext context) {
        this.context = context;
    }

    public void setRequestBody(Object requestBody) {
        this.requestBody = requestBody;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public URI getURI() {
        return this.uri;
    }

    public HttpHeaders getHeaders() {
        return this.httpHeaders;
    }

    public OutputStream getBody() {
        return null;
    }

    public ClientHttpResponse execute() {
        this.path = this.findUriPath(this.uri);
        this.requestMeta = this.createRequestMeta(this.method.name(), this.uri);
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(this.uri.getRawSchemeSpecificPart());
        this.queryParams = queryStringDecoder.parameters();
        Object[] args = this.collectArguments();
        return this.invoke(args);
    }

    protected RequestMeta createRequestMeta(String httpMethod, URI uri) {
        String microserviceName = uri.getAuthority();
        ReferenceConfig referenceConfig = SCBEngine.getInstance().getReferenceConfigForInvoke(microserviceName);
        MicroserviceMeta microserviceMeta = referenceConfig.getMicroserviceMeta();
        ServicePathManager servicePathManager = ServicePathManager.getServicePathManager((MicroserviceMeta)microserviceMeta);
        if (servicePathManager == null) {
            throw new Error(String.format("no schema defined for %s:%s", microserviceMeta.getAppId(), microserviceMeta.getName()));
        }
        OperationLocator locator = servicePathManager.consumerLocateOperation(this.path, httpMethod);
        RestOperationMeta swaggerRestOperation = locator.getOperation();
        Map pathParams = locator.getPathVarMap();
        return new RequestMeta(referenceConfig, swaggerRestOperation, pathParams);
    }

    protected String findUriPath(URI uri) {
        return uri.getRawPath();
    }

    protected Invocation prepareInvocation(Object[] args) {
        Invocation invocation = InvocationFactory.forConsumer((ReferenceConfig)this.requestMeta.getReferenceConfig(), (OperationMeta)this.requestMeta.getOperationMeta(), (Object[])args);
        invocation.getHandlerContext().put("rest-client-request-path", this.path + "?" + this.uri.getRawQuery());
        if (this.context != null) {
            invocation.addContext(this.context);
        }
        invocation.getHandlerContext().put("servicecomb-rest-consumer-header", this.httpHeaders);
        return invocation;
    }

    private CseClientHttpResponse invoke(Object[] args) {
        Invocation invocation = this.prepareInvocation(args);
        Response response = this.doInvoke(invocation);
        if (response.isSuccessed()) {
            return new CseClientHttpResponse(response);
        }
        throw ExceptionFactory.convertConsumerException((Throwable)((Throwable)response.getResult()));
    }

    protected Response doInvoke(Invocation invocation) {
        return InvokerUtils.innerSyncInvoke((Invocation)invocation);
    }

    protected Object[] collectArguments() {
        CommonToHttpServletRequest mockRequest = new CommonToHttpServletRequest(this.requestMeta.getPathParams(), this.queryParams, (Map<String, List<String>>)this.httpHeaders, this.requestBody, this.requestMeta.getSwaggerRestOperation().isFormData());
        return RestCodec.restToArgs((HttpServletRequest)mockRequest, (RestOperationMeta)this.requestMeta.getSwaggerRestOperation());
    }
}

