/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.loadbalance.ServiceCombServer;
import org.apache.servicecomb.loadbalance.ServiceCombServerStats;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceInstancePing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCombLoadBalancerStats {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceCombLoadBalancerStats.class);
    private static final int SERVERSTATS_EXPIRE_MINUTES = 10;
    private static final long TIMER_INTERVAL_MILLIS = 10000L;
    private static final LoadingCache<ServiceCombServer, ServiceCombServerStats> SERVER_STATES_CACHE = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<ServiceCombServer, ServiceCombServerStats>(){

        public void onRemoval(RemovalNotification<ServiceCombServer, ServiceCombServerStats> notification) {
            LOGGER.info("stats of instance {} removed.", (Object)((ServiceCombServer)((Object)notification.getKey())).getInstance().getInstanceId());
        }
    }).build((CacheLoader)new CacheLoader<ServiceCombServer, ServiceCombServerStats>(){

        public ServiceCombServerStats load(ServiceCombServer server) {
            return new ServiceCombServerStats();
        }
    });
    public static final ServiceCombLoadBalancerStats INSTANCE = new ServiceCombLoadBalancerStats();

    private ServiceCombLoadBalancerStats() {
        Timer timer = new Timer("LoadBalancerStatsTimer", true);
        timer.schedule(new TimerTask(){
            private MicroserviceInstancePing ping = (MicroserviceInstancePing)SPIServiceUtils.getPriorityHighestService(MicroserviceInstancePing.class);

            @Override
            public void run() {
                try {
                    ConcurrentMap allServers = SERVER_STATES_CACHE.asMap();
                    for (ServiceCombServer server : allServers.keySet()) {
                        ServiceCombServerStats stats = (ServiceCombServerStats)allServers.get((Object)server);
                        if (System.currentTimeMillis() - stats.getLastVisitTime() >= 10000L || this.ping.ping(server.getInstance())) continue;
                        LOGGER.info("ping mark server {} failure.", (Object)server.getInstance().getInstanceId());
                        ServiceCombLoadBalancerStats.this.markFailure(server);
                    }
                }
                catch (Throwable e) {
                    LOGGER.warn("LoadBalancerStatsTimer error.", e);
                }
            }
        }, 10000L, 10000L);
    }

    public void markIsolated(ServiceCombServer server, boolean isolated) {
        try {
            ((ServiceCombServerStats)SERVER_STATES_CACHE.get((Object)server)).markIsolated(isolated);
        }
        catch (ExecutionException e) {
            LOGGER.error("Not expected to happen, maybe a bug.", (Throwable)e);
        }
    }

    public void markSuccess(ServiceCombServer server) {
        try {
            ((ServiceCombServerStats)SERVER_STATES_CACHE.get((Object)server)).markSuccess();
        }
        catch (ExecutionException e) {
            LOGGER.error("Not expected to happen, maybe a bug.", (Throwable)e);
        }
    }

    public void markFailure(ServiceCombServer server) {
        try {
            ((ServiceCombServerStats)SERVER_STATES_CACHE.get((Object)server)).markFailure();
        }
        catch (ExecutionException e) {
            LOGGER.error("Not expected to happen, maybe a bug.", (Throwable)e);
        }
    }

    public ServiceCombServerStats getServiceCombServerStats(ServiceCombServer server) {
        try {
            return (ServiceCombServerStats)SERVER_STATES_CACHE.get((Object)server);
        }
        catch (ExecutionException e) {
            LOGGER.error("Not expected to happen, maybe a bug.", (Throwable)e);
            return null;
        }
    }

    public ServiceCombServer getServiceCombServer(MicroserviceInstance instance) {
        for (ServiceCombServer server : SERVER_STATES_CACHE.asMap().keySet()) {
            if (!server.getInstance().equals((Object)instance)) continue;
            return server;
        }
        return null;
    }
}

