/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance;

import com.google.common.collect.Lists;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.RoundRobinRule;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.servicecomb.foundation.common.utils.JvmUtils;
import org.apache.servicecomb.loadbalance.ExtensionsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RuleClassNameExtentionsFactory
implements ExtensionsFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuleClassNameExtentionsFactory.class);
    private static final Collection<String> ACCEPT_KEYS = Lists.newArrayList((Object[])new String[]{"NFLoadBalancerRuleClassName"});

    @Override
    public boolean isSupport(String key, String value) {
        return ACCEPT_KEYS.contains(key) && StringUtils.isNotEmpty((String)value);
    }

    @Override
    public IRule createLoadBalancerRule(String ruleName) {
        IRule rule;
        try {
            rule = (IRule)Class.forName(ruleName, true, JvmUtils.findClassLoader()).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LOGGER.warn("Loadbalance rule [{}] is incorrect, using default RoundRobinRule.", (Object)ruleName);
            rule = new RoundRobinRule();
        }
        return rule;
    }
}

