/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance;

import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.reactive.ExecutionContext;
import com.netflix.loadbalancer.reactive.ExecutionInfo;
import com.netflix.loadbalancer.reactive.ExecutionListener;
import com.netflix.loadbalancer.reactive.LoadBalancerCommand;
import com.netflix.loadbalancer.reactive.ServerOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.core.Handler;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.exception.ExceptionUtils;
import org.apache.servicecomb.core.provider.consumer.SyncResponseExecutor;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.loadbalance.Configuration;
import org.apache.servicecomb.loadbalance.ExtensionsManager;
import org.apache.servicecomb.loadbalance.LoadBalancer;
import org.apache.servicecomb.loadbalance.LoadBalancerCreator;
import org.apache.servicecomb.loadbalance.ServiceCombLoadBalancerStats;
import org.apache.servicecomb.loadbalance.ServiceCombServer;
import org.apache.servicecomb.loadbalance.filter.ServerDiscoveryFilter;
import org.apache.servicecomb.serviceregistry.discovery.DiscoveryContext;
import org.apache.servicecomb.serviceregistry.discovery.DiscoveryFilter;
import org.apache.servicecomb.serviceregistry.discovery.DiscoveryTree;
import org.apache.servicecomb.serviceregistry.discovery.DiscoveryTreeNode;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class LoadbalanceHandler
implements Handler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadbalanceHandler.class);
    private static final ExecutorService RETRY_POOL = Executors.newCachedThreadPool(new ThreadFactory(){
        private AtomicInteger count = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "retry-pool-thread-" + this.count.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }
    });
    private DiscoveryTree discoveryTree = new DiscoveryTree();
    private volatile Map<String, LoadBalancerCreator> loadBalancerMap = new ConcurrentHashMapEx();
    private final Object lock = new Object();
    private String policy = null;
    private String strategy = null;

    public LoadbalanceHandler() {
        this.discoveryTree.loadFromSPI(DiscoveryFilter.class);
        this.discoveryTree.addFilter((DiscoveryFilter)new ServerDiscoveryFilter());
        this.discoveryTree.sort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Invocation invocation, AsyncResponse asyncResp) throws Exception {
        boolean isRuleNotChanged;
        String policy = Configuration.INSTANCE.getPolicy(invocation.getMicroserviceName());
        String strategy = Configuration.INSTANCE.getRuleStrategyName(invocation.getMicroserviceName());
        boolean bl = isRuleNotChanged = this.isEqual(policy, this.policy) && this.isEqual(strategy, this.strategy);
        if (!isRuleNotChanged) {
            Object object = this.lock;
            synchronized (object) {
                this.clearLoadBalancer();
            }
        }
        this.policy = policy;
        this.strategy = strategy;
        LoadBalancer loadBalancer = this.getOrCreateLoadBalancer(invocation);
        if (!Configuration.INSTANCE.isRetryEnabled(invocation.getMicroserviceName())) {
            this.send(invocation, asyncResp, loadBalancer);
        } else {
            this.sendWithRetry(invocation, asyncResp, loadBalancer);
        }
    }

    private void clearLoadBalancer() {
        for (LoadBalancerCreator creator : this.loadBalancerMap.values()) {
            creator.shutdown();
        }
        this.loadBalancerMap.clear();
    }

    protected void setTransactionControlFilter(String microserviceName) {
        String policyClsName = Configuration.INSTANCE.getFlowsplitFilterPolicy(microserviceName);
        if (!policyClsName.isEmpty()) {
            LOGGER.error("servicecomb.loadbalance.%s.transactionControl.policy is not supported anymore.You can change this class to SPI, and filters will be loaded by SPI.");
        }
    }

    private void send(Invocation invocation, AsyncResponse asyncResp, LoadBalancer chosenLB) throws Exception {
        long time = System.currentTimeMillis();
        ServiceCombServer server = (ServiceCombServer)chosenLB.chooseServer(invocation);
        if (null == server) {
            asyncResp.consumerFail((Throwable)ExceptionUtils.lbAddressNotFound((String)invocation.getMicroserviceName(), (String)invocation.getMicroserviceVersionRule(), (String)invocation.getConfigTransportName()));
            return;
        }
        chosenLB.getLoadBalancerStats().incrementNumRequests((Server)server);
        invocation.setEndpoint(server.getEndpoint());
        invocation.next(resp -> {
            chosenLB.getLoadBalancerStats().noteResponseTime((Server)server, (double)(System.currentTimeMillis() - time));
            if (this.isFailedResponse(resp)) {
                chosenLB.getLoadBalancerStats().incrementSuccessiveConnectionFailureCount((Server)server);
                ServiceCombLoadBalancerStats.INSTANCE.markFailure(server);
            } else {
                chosenLB.getLoadBalancerStats().incrementActiveRequestsCount((Server)server);
                ServiceCombLoadBalancerStats.INSTANCE.markSuccess(server);
            }
            asyncResp.handle(resp);
        });
    }

    private void sendWithRetry(final Invocation invocation, final AsyncResponse asyncResp, final LoadBalancer chosenLB) throws Exception {
        SyncResponseExecutor orginExecutor;
        final long time = System.currentTimeMillis();
        final int currentHandler = invocation.getHandlerIndex();
        if (invocation.getResponseExecutor() instanceof SyncResponseExecutor) {
            orginExecutor = (SyncResponseExecutor)invocation.getResponseExecutor();
            Executor newExecutor = new Executor(){

                @Override
                public void execute(Runnable command) {
                    RETRY_POOL.submit(command);
                }
            };
            invocation.setResponseExecutor(newExecutor);
        } else {
            orginExecutor = null;
            Object newExecutor = null;
        }
        ExecutionListener<Invocation, Response> listener = new ExecutionListener<Invocation, Response>(){

            public void onExecutionStart(ExecutionContext<Invocation> context) throws ExecutionListener.AbortExecutionException {
            }

            public void onStartWithServer(ExecutionContext<Invocation> context, ExecutionInfo info) throws ExecutionListener.AbortExecutionException {
            }

            public void onExceptionWithServer(ExecutionContext<Invocation> context, Throwable exception, ExecutionInfo info) {
                LOGGER.error("onExceptionWithServer operation {}; msg {}; server {}", new Object[]{((Invocation)context.getRequest()).getInvocationQualifiedName(), exception.getMessage(), ((Invocation)context.getRequest()).getEndpoint()});
            }

            public void onExecutionSuccess(ExecutionContext<Invocation> context, Response response, ExecutionInfo info) {
                if (orginExecutor != null) {
                    orginExecutor.execute(() -> asyncResp.complete(response));
                } else {
                    asyncResp.complete(response);
                }
            }

            public void onExecutionFailed(ExecutionContext<Invocation> context, Throwable finalException, ExecutionInfo info) {
                if (orginExecutor != null) {
                    orginExecutor.execute(() -> asyncResp.consumerFail(finalException));
                } else {
                    asyncResp.consumerFail(finalException);
                }
            }
        };
        ArrayList<3> listeners = new ArrayList<3>(0);
        listeners.add(listener);
        ExecutionContext context = new ExecutionContext((Object)invocation, null, null, null);
        LoadBalancerCommand command = LoadBalancerCommand.builder().withLoadBalancer((ILoadBalancer)chosenLB).withServerLocator((Object)invocation).withRetryHandler(ExtensionsManager.createRetryHandler(invocation.getMicroserviceName())).withListeners(listeners).withExecutionContext(context).build();
        Observable observable = command.submit((ServerOperation)new ServerOperation<Response>(){

            public Observable<Response> call(Server s) {
                return Observable.create(f -> {
                    try {
                        ServiceCombServer server = (ServiceCombServer)s;
                        chosenLB.getLoadBalancerStats().incrementNumRequests(s);
                        invocation.setHandlerIndex(currentHandler);
                        invocation.setEndpoint(server.getEndpoint());
                        invocation.next(resp -> {
                            if (LoadbalanceHandler.this.isFailedResponse(resp)) {
                                LOGGER.error("service {}, call error, msg is {}, server is {} ", new Object[]{invocation.getInvocationQualifiedName(), ((Throwable)resp.getResult()).getMessage(), s});
                                chosenLB.getLoadBalancerStats().incrementSuccessiveConnectionFailureCount(s);
                                ServiceCombLoadBalancerStats.INSTANCE.markFailure(server);
                                f.onError((Throwable)resp.getResult());
                            } else {
                                chosenLB.getLoadBalancerStats().incrementActiveRequestsCount(s);
                                chosenLB.getLoadBalancerStats().noteResponseTime(s, (double)(System.currentTimeMillis() - time));
                                ServiceCombLoadBalancerStats.INSTANCE.markSuccess(server);
                                f.onNext((Object)resp);
                                f.onCompleted();
                            }
                        });
                    }
                    catch (Exception e) {
                        LOGGER.error("execution error, msg is " + e.getMessage());
                        f.onError((Throwable)e);
                    }
                });
            }
        });
        observable.subscribe(response -> {}, error -> {}, () -> {});
    }

    protected boolean isFailedResponse(Response resp) {
        if (resp.isFailed()) {
            if (InvocationException.class.isInstance(resp.getResult())) {
                InvocationException e = (InvocationException)resp.getResult();
                return e.getStatusCode() == 490;
            }
            return true;
        }
        return false;
    }

    protected LoadBalancer getOrCreateLoadBalancer(Invocation invocation) {
        DiscoveryContext context = new DiscoveryContext();
        context.setInputParameters((Object)invocation);
        DiscoveryTreeNode serversVersionedCache = this.discoveryTree.discovery(context, invocation.getAppId(), invocation.getMicroserviceName(), invocation.getMicroserviceVersionRule());
        LoadBalancerCreator loadBalancerCreator = this.loadBalancerMap.computeIfAbsent(serversVersionedCache.name(), name -> this.createLoadBalancerCreator(invocation.getMicroserviceName()));
        loadBalancerCreator.setServerList((List)serversVersionedCache.data());
        this.setTransactionControlFilter(invocation.getMicroserviceName());
        this.loadServerListFilters();
        return loadBalancerCreator.createLoadBalancer(invocation);
    }

    private LoadBalancerCreator createLoadBalancerCreator(String microserviceName) {
        IRule rule = ExtensionsManager.createLoadBalancerRule(microserviceName);
        LoadBalancerCreator creator = new LoadBalancerCreator(rule, microserviceName);
        return creator;
    }

    private void loadServerListFilters() {
        String filterNames = Configuration.getStringProperty(null, "servicecomb.loadbalance.serverListFilters");
        if (!StringUtils.isEmpty((CharSequence)filterNames)) {
            LOGGER.error("Server list implementation changed to SPI. Configuration servicecomb.loadbalance.serverListFilters is not used any more. For ServiceComb defined filters, you do not need config and can remove this configuration safely. If you define your own filter, need to change it to SPI to make it work.");
        }
    }

    public boolean isEqual(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }
}

