/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.qps.strategy;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.servicecomb.qps.strategy.AbstractQpsStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeakyBucketStrategy
extends AbstractQpsStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(LeakyBucketStrategy.class);
    private final AtomicLong requestCount = new AtomicLong();
    private volatile long lastTime;
    private long remainder = 0L;
    private static final String STRATEGY_NAME = "LeakyBucket";

    @Override
    public boolean isLimitNewRequest() {
        if (this.getQpsLimit() == null) {
            throw new IllegalStateException("should not happen");
        }
        if (this.getBucketLimit() == null) {
            this.setBucketLimit(Math.max(2L * this.getQpsLimit(), Integer.MAX_VALUE));
        }
        long nowTime = System.currentTimeMillis();
        long leakCount = (nowTime - this.lastTime + this.remainder) / 1000L * this.getQpsLimit();
        this.remainder = (nowTime - this.lastTime + this.remainder) % 1000L;
        if (this.requestCount.longValue() > leakCount) {
            this.requestCount.addAndGet(-leakCount);
        } else {
            this.requestCount.set(0L);
        }
        this.lastTime = nowTime;
        if (this.requestCount.longValue() < this.getBucketLimit()) {
            this.requestCount.incrementAndGet();
            return false;
        }
        LOGGER.warn("qps flowcontrol open, qpsLimit is {} and tps is {}", (Object)this.getQpsLimit(), (Object)(this.requestCount.longValue() + 1L));
        return true;
    }

    @Override
    public String name() {
        return STRATEGY_NAME;
    }
}

