/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.qps.strategy;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.servicecomb.qps.strategy.AbstractQpsStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedWindowStrategy
extends AbstractQpsStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(FixedWindowStrategy.class);
    private volatile long msCycleBegin;
    private AtomicLong requestCount = new AtomicLong();
    private volatile long lastRequestCount = 1L;
    private static final int CYCLE_LENGTH = 1000;
    private static final String STRATEGY_NAME = "FixedWindow";

    @Override
    public boolean isLimitNewRequest() {
        boolean isLimitRequest;
        if (this.getQpsLimit() == null) {
            throw new IllegalStateException("should not happen");
        }
        long newCount = this.requestCount.incrementAndGet();
        long msNow = System.currentTimeMillis();
        if (msNow - this.msCycleBegin > 1000L || msNow < this.msCycleBegin) {
            this.lastRequestCount = newCount;
            this.msCycleBegin = msNow;
        }
        boolean bl = isLimitRequest = newCount - this.lastRequestCount >= this.getQpsLimit();
        if (isLimitRequest) {
            LOGGER.warn("qps flowcontrol open, qpsLimit is {} and tps is {}", (Object)this.getQpsLimit(), (Object)(newCount - this.lastRequestCount + 1L));
        }
        return isLimitRequest;
    }

    @Override
    public String name() {
        return STRATEGY_NAME;
    }
}

