/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.qps;

import com.netflix.config.DynamicProperty;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.common.exceptions.ServiceCombException;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.qps.QpsStrategy;
import org.apache.servicecomb.qps.strategy.AbstractQpsStrategy;
import org.apache.servicecomb.qps.strategy.IStrategyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QpsControllerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(QpsControllerManager.class);
    public static final String SEPARATOR = ".";
    private final Map<String, AbstractQpsStrategy> configQpsControllerMap = new ConcurrentHashMapEx();
    private final Map<String, AbstractQpsStrategy> qualifiedNameControllerMap = new ConcurrentHashMapEx();
    private AbstractQpsStrategy globalQpsStrategy;
    private final String limitKeyPrefix;
    private final String bucketKeyPrefix;
    private final String globalLimitKey;
    private final String globalBucketKey;

    public QpsControllerManager(boolean isProvider) {
        if (isProvider) {
            this.limitKeyPrefix = "servicecomb.flowcontrol.Provider.qps.limit.";
            this.bucketKeyPrefix = "servicecomb.flowcontrol.Provider.qps.bucket.";
            this.globalLimitKey = "servicecomb.flowcontrol.Provider.qps.global.limit";
            this.globalBucketKey = "servicecomb.flowcontrol.Provider.qps.global.bucket";
        } else {
            this.limitKeyPrefix = "servicecomb.flowcontrol.Consumer.qps.limit.";
            this.bucketKeyPrefix = "servicecomb.flowcontrol.Consumer.qps.bucket.";
            this.globalLimitKey = "servicecomb.flowcontrol.Consumer.qps.global.limit";
            this.globalBucketKey = "servicecomb.flowcontrol.Consumer.qps.global.bucket";
        }
        this.initGlobalQpsController();
    }

    public QpsStrategy getOrCreate(String microserviceName, Invocation invocation) {
        String name = this.validatedName(microserviceName);
        return this.qualifiedNameControllerMap.computeIfAbsent(name + SEPARATOR + invocation.getOperationMeta().getSchemaQualifiedName(), key -> this.create((String)key, name, invocation));
    }

    private String validatedName(String microserviceName) {
        String name = microserviceName;
        if (StringUtils.isEmpty((CharSequence)microserviceName)) {
            name = "ANY";
        }
        return name;
    }

    private AbstractQpsStrategy create(String qualifiedNameKey, String microserviceName, Invocation invocation) {
        this.createForService(qualifiedNameKey, microserviceName, invocation);
        String qualifiedAnyServiceName = "ANY" + qualifiedNameKey.substring(microserviceName.length());
        this.createForService(qualifiedAnyServiceName, "ANY", invocation);
        AbstractQpsStrategy strategy = this.searchQpsController(qualifiedNameKey);
        if (strategy == null) {
            strategy = this.searchQpsController(qualifiedAnyServiceName);
        }
        if (strategy == null) {
            return this.globalQpsStrategy;
        }
        return strategy;
    }

    private void createForService(String qualifiedNameKey, String microserviceName, Invocation invocation) {
        this.createQpsControllerIfNotExist(microserviceName);
        this.createQpsControllerIfNotExist(qualifiedNameKey.substring(0, microserviceName.length() + invocation.getSchemaId().length() + 1));
        this.createQpsControllerIfNotExist(qualifiedNameKey);
    }

    private AbstractQpsStrategy searchQpsController(String qualifiedNameKey) {
        AbstractQpsStrategy qpsStrategy = this.configQpsControllerMap.get(qualifiedNameKey);
        if (this.isValidQpsController(qpsStrategy)) {
            return qpsStrategy;
        }
        int index = qualifiedNameKey.lastIndexOf(SEPARATOR);
        while (index > 0) {
            qpsStrategy = this.configQpsControllerMap.get(qualifiedNameKey.substring(0, index));
            if (this.isValidQpsController(qpsStrategy)) {
                return qpsStrategy;
            }
            index = qualifiedNameKey.lastIndexOf(SEPARATOR, index - 1);
        }
        if (this.isValidQpsController(qpsStrategy)) {
            return qpsStrategy;
        }
        return null;
    }

    private boolean keyMatch(String configKey, Map.Entry<String, AbstractQpsStrategy> controllerEntry) {
        return controllerEntry.getKey().equals(configKey) || controllerEntry.getKey().startsWith(configKey + SEPARATOR);
    }

    private boolean isValidQpsController(AbstractQpsStrategy qpsStrategy) {
        return null != qpsStrategy && null != qpsStrategy.getQpsLimit();
    }

    private void createQpsControllerIfNotExist(String configKey) {
        if (this.configQpsControllerMap.containsKey(configKey)) {
            return;
        }
        LOGGER.info("Create qpsController, configKey = [{}]", (Object)configKey);
        DynamicProperty limitProperty = DynamicProperty.getInstance((String)(this.limitKeyPrefix + configKey));
        DynamicProperty bucketProperty = DynamicProperty.getInstance((String)(this.bucketKeyPrefix + configKey));
        DynamicProperty strategyProperty = DynamicProperty.getInstance((String)"servicecomb.flowcontrol.strategy");
        AbstractQpsStrategy qpsStrategy = this.chooseStrategy(configKey, limitProperty.getLong(), bucketProperty.getLong(), strategyProperty.getString());
        strategyProperty.addCallback(() -> {
            AbstractQpsStrategy innerQpsStrategy = this.chooseStrategy(configKey, limitProperty.getLong(), bucketProperty.getLong(), strategyProperty.getString());
            this.configQpsControllerMap.put(configKey, innerQpsStrategy);
            LOGGER.info("Global flow control strategy update, value = [{}]", (Object)strategyProperty.getString());
            this.updateObjMap(configKey);
        });
        limitProperty.addCallback(() -> {
            qpsStrategy.setQpsLimit(limitProperty.getLong());
            LOGGER.info("Qps limit updated, configKey = [{}], value = [{}]", (Object)configKey, (Object)limitProperty.getString());
            this.updateObjMap(configKey);
        });
        bucketProperty.addCallback(() -> {
            qpsStrategy.setBucketLimit(bucketProperty.getLong());
            LOGGER.info("bucket limit updated, configKey = [{}], value = [{}]", (Object)configKey, (Object)bucketProperty.getString());
            this.updateObjMap(configKey);
        });
        this.configQpsControllerMap.put(configKey, qpsStrategy);
    }

    protected void updateObjMap(String configKey) {
        Iterator<Map.Entry<String, AbstractQpsStrategy>> it = this.qualifiedNameControllerMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, AbstractQpsStrategy> entry = it.next();
            if (!this.keyMatch(configKey, entry)) continue;
            AbstractQpsStrategy qpsStrategy = this.searchQpsController(entry.getKey());
            if (qpsStrategy != null) {
                entry.setValue(qpsStrategy);
                LOGGER.info("QpsController updated, operationId = [{}], configKey = [{}], qpsLimit = [{}]", new Object[]{entry.getKey(), qpsStrategy.getKey(), qpsStrategy.getQpsLimit()});
                continue;
            }
            it.remove();
        }
    }

    private void initGlobalQpsController() {
        DynamicProperty globalLimitProperty = DynamicProperty.getInstance((String)this.globalLimitKey);
        DynamicProperty globalBucketProperty = DynamicProperty.getInstance((String)this.globalBucketKey);
        DynamicProperty globalStrategyProperty = DynamicProperty.getInstance((String)"servicecomb.flowcontrol.strategy");
        this.globalQpsStrategy = this.chooseStrategy(this.globalLimitKey, globalLimitProperty.getLong(Long.valueOf(Integer.MAX_VALUE)), globalBucketProperty.getLong(), globalStrategyProperty.getString());
        globalStrategyProperty.addCallback(() -> {
            this.globalQpsStrategy = this.chooseStrategy(this.globalLimitKey, globalLimitProperty.getLong(Long.valueOf(Integer.MAX_VALUE)), globalBucketProperty.getLong(), globalStrategyProperty.getString());
            LOGGER.info("Global flow control strategy update, value = [{}]", (Object)globalStrategyProperty.getString());
        });
        globalLimitProperty.addCallback(() -> {
            this.globalQpsStrategy.setQpsLimit(globalLimitProperty.getLong(Long.valueOf(Integer.MAX_VALUE)));
            LOGGER.info("Global qps limit update, value = [{}]", (Object)globalLimitProperty.getLong());
        });
        globalBucketProperty.addCallback(() -> {
            this.globalQpsStrategy.setBucketLimit(globalBucketProperty.getLong());
            LOGGER.info("Global bucket limit update, value = [{}]", (Object)globalBucketProperty.getLong());
        });
    }

    private AbstractQpsStrategy chooseStrategy(String configKey, Long limit, Long bucket, String strategyName) {
        IStrategyFactory strategyFactory;
        if (StringUtils.isEmpty((CharSequence)strategyName)) {
            strategyName = "FixedWindow";
        }
        AbstractQpsStrategy strategy = null;
        List strategyFactories = SPIServiceUtils.getOrLoadSortedService(IStrategyFactory.class);
        Iterator iterator = strategyFactories.iterator();
        while (iterator.hasNext() && (strategy = (strategyFactory = (IStrategyFactory)iterator.next()).createStrategy(strategyName)) == null) {
        }
        if (strategy == null) {
            throw new ServiceCombException("the qps strategy name " + strategyName + " is not exist , please check.");
        }
        strategy.setKey(configKey);
        strategy.setQpsLimit(limit);
        strategy.setBucketLimit(bucket);
        return strategy;
    }
}

