/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.qps;

import com.netflix.config.DynamicProperty;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.common.exceptions.ServiceCombException;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.qps.QpsStrategy;
import org.apache.servicecomb.qps.strategy.AbstractQpsStrategy;
import org.apache.servicecomb.qps.strategy.IStrategyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QpsControllerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(QpsControllerManager.class);
    protected final Map<String, AbstractQpsStrategy> configQpsControllerMap = new ConcurrentHashMapEx();
    protected final Map<String, AbstractQpsStrategy> qualifiedNameControllerMap = new ConcurrentHashMapEx();
    protected AbstractQpsStrategy globalQpsStrategy;
    public static final String SEPARATOR = ".";
    private String limitKeyPrefix;
    private String bucketKeyPrefix;

    public QpsStrategy getOrCreate(String microserviceName, Invocation invocation) {
        return this.qualifiedNameControllerMap.computeIfAbsent(microserviceName + SEPARATOR + invocation.getOperationMeta().getSchemaQualifiedName(), key -> this.create((String)key, microserviceName, invocation));
    }

    protected AbstractQpsStrategy create(String qualifiedNameKey, String microserviceName, Invocation invocation) {
        this.createQpsControllerIfNotExist(microserviceName);
        this.createQpsControllerIfNotExist(qualifiedNameKey.substring(0, microserviceName.length() + invocation.getSchemaId().length() + 1));
        this.createQpsControllerIfNotExist(qualifiedNameKey);
        return this.searchQpsController(qualifiedNameKey);
    }

    protected AbstractQpsStrategy searchQpsController(String qualifiedNameKey) {
        AbstractQpsStrategy qpsStrategy = this.configQpsControllerMap.get(qualifiedNameKey);
        if (this.isValidQpsController(qpsStrategy)) {
            return qpsStrategy;
        }
        int index = qualifiedNameKey.lastIndexOf(SEPARATOR);
        while (index > 0) {
            qpsStrategy = this.configQpsControllerMap.get(qualifiedNameKey.substring(0, index));
            if (this.isValidQpsController(qpsStrategy)) {
                return qpsStrategy;
            }
            index = qualifiedNameKey.lastIndexOf(SEPARATOR, index - 1);
        }
        if (this.isValidQpsController(qpsStrategy)) {
            return qpsStrategy;
        }
        if (null != this.globalQpsStrategy) {
            return this.globalQpsStrategy;
        }
        return qpsStrategy;
    }

    private boolean keyMatch(String configKey, Map.Entry<String, AbstractQpsStrategy> controllerEntry) {
        return controllerEntry.getKey().equals(configKey) || controllerEntry.getKey().startsWith(configKey + SEPARATOR);
    }

    private boolean isValidQpsController(AbstractQpsStrategy qpsStrategy) {
        return null != qpsStrategy && null != qpsStrategy.getQpsLimit();
    }

    private void createQpsControllerIfNotExist(String configKey) {
        if (this.configQpsControllerMap.keySet().contains(configKey)) {
            return;
        }
        LOGGER.info("Create qpsController, configKey = [{}]", (Object)configKey);
        DynamicProperty limitProperty = DynamicProperty.getInstance((String)(this.limitKeyPrefix + configKey));
        DynamicProperty bucketProperty = DynamicProperty.getInstance((String)(this.bucketKeyPrefix + configKey));
        DynamicProperty strategyProperty = DynamicProperty.getInstance((String)"servicecomb.flowcontrol.strategy");
        AbstractQpsStrategy qpsStrategy = this.chooseStrategy(configKey, limitProperty.getLong(), bucketProperty.getLong(), strategyProperty.getString());
        strategyProperty.addCallback(() -> {
            AbstractQpsStrategy innerQpsStrategy = this.chooseStrategy(configKey, limitProperty.getLong(), bucketProperty.getLong(), strategyProperty.getString());
            this.configQpsControllerMap.put(configKey, innerQpsStrategy);
            LOGGER.info("Global flow control strategy update, value = [{}]", (Object)strategyProperty.getString());
            this.updateObjMap(configKey);
        });
        limitProperty.addCallback(() -> {
            qpsStrategy.setQpsLimit(limitProperty.getLong());
            LOGGER.info("Qps limit updated, configKey = [{}], value = [{}]", (Object)configKey, (Object)limitProperty.getString());
            this.updateObjMap(configKey);
        });
        bucketProperty.addCallback(() -> {
            qpsStrategy.setBucketLimit(bucketProperty.getLong());
            LOGGER.info("bucket limit updated, configKey = [{}], value = [{}]", (Object)configKey, (Object)bucketProperty.getString());
            this.updateObjMap(configKey);
        });
        this.configQpsControllerMap.put(configKey, qpsStrategy);
    }

    protected void updateObjMap(String configKey) {
        for (Map.Entry<String, AbstractQpsStrategy> controllerEntry : this.qualifiedNameControllerMap.entrySet()) {
            if (!this.keyMatch(configKey, controllerEntry)) continue;
            AbstractQpsStrategy qpsStrategy = this.searchQpsController(controllerEntry.getKey());
            controllerEntry.setValue(qpsStrategy);
            LOGGER.info("QpsController updated, operationId = [{}], configKey = [{}], qpsLimit = [{}]", new Object[]{controllerEntry.getKey(), qpsStrategy.getKey(), qpsStrategy.getQpsLimit()});
        }
    }

    public QpsControllerManager setLimitKeyPrefix(String limitKeyPrefix) {
        this.limitKeyPrefix = limitKeyPrefix;
        return this;
    }

    public QpsControllerManager setBucketKeyPrefix(String bucketKeyPrefix) {
        this.bucketKeyPrefix = bucketKeyPrefix;
        return this;
    }

    public QpsControllerManager setGlobalQpsStrategy(String globalLimitKey, String globalBucketKey) {
        DynamicProperty globalLimitProperty = DynamicProperty.getInstance((String)globalLimitKey);
        DynamicProperty globalBucketProperty = DynamicProperty.getInstance((String)globalBucketKey);
        DynamicProperty globalStrategyProperty = DynamicProperty.getInstance((String)"servicecomb.flowcontrol.strategy");
        this.globalQpsStrategy = this.chooseStrategy(globalLimitKey, globalLimitProperty.getLong(), globalBucketProperty.getLong(), globalStrategyProperty.getString());
        globalStrategyProperty.addCallback(() -> {
            this.globalQpsStrategy = this.chooseStrategy(globalLimitKey, globalLimitProperty.getLong(), globalBucketProperty.getLong(), globalStrategyProperty.getString());
            LOGGER.info("Global flow control strategy update, value = [{}]", (Object)globalStrategyProperty.getString());
        });
        globalLimitProperty.addCallback(() -> {
            this.globalQpsStrategy.setQpsLimit(globalLimitProperty.getLong());
            LOGGER.info("Global qps limit update, value = [{}]", (Object)globalLimitProperty.getInteger());
        });
        globalBucketProperty.addCallback(() -> {
            this.globalQpsStrategy.setBucketLimit(globalBucketProperty.getLong());
            LOGGER.info("Global bucket limit update, value = [{}]", (Object)globalBucketProperty.getInteger());
        });
        return this;
    }

    private AbstractQpsStrategy chooseStrategy(String globalConfigKey, Long limit, Long bucket, String strategyName) {
        IStrategyFactory strategyFactory;
        if (StringUtils.isEmpty((CharSequence)strategyName)) {
            strategyName = "FixedWindow";
        }
        AbstractQpsStrategy strategy = null;
        List strategyFactories = SPIServiceUtils.getOrLoadSortedService(IStrategyFactory.class);
        Iterator iterator = strategyFactories.iterator();
        while (iterator.hasNext() && (strategy = (strategyFactory = (IStrategyFactory)iterator.next()).createStrategy(strategyName)) == null) {
        }
        if (strategy == null) {
            throw new ServiceCombException("the qps strategy name " + strategyName + " is not exist , please check.");
        }
        strategy.setKey(globalConfigKey);
        strategy.setQpsLimit(limit);
        strategy.setBucketLimit(bucket);
        return strategy;
    }

    public QpsStrategy getGlobalQpsStrategy() {
        return this.globalQpsStrategy;
    }
}

