/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.qps;

import org.apache.servicecomb.core.Handler;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.qps.Config;
import org.apache.servicecomb.qps.QpsConst;
import org.apache.servicecomb.qps.QpsControllerManager;
import org.apache.servicecomb.qps.QpsStrategy;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.springframework.util.StringUtils;

public class ProviderQpsFlowControlHandler
implements Handler {
    static final QpsControllerManager qpsControllerMgr = new QpsControllerManager().setLimitKeyPrefix("servicecomb.flowcontrol.Provider.qps.limit.").setBucketKeyPrefix("servicecomb.flowcontrol.Provider.qps.bucket.").setGlobalQpsStrategy("servicecomb.flowcontrol.Provider.qps.global.limit", "servicecomb.flowcontrol.Provider.qps.global.bucket");

    public void handle(Invocation invocation, AsyncResponse asyncResp) throws Exception {
        if (invocation.getHandlerIndex() > 0) {
            invocation.next(asyncResp);
            return;
        }
        if (!Config.INSTANCE.isProviderEnabled()) {
            return;
        }
        String microserviceName = invocation.getContext("x-cse-src-microservice");
        QpsStrategy qpsStrategy = StringUtils.isEmpty((Object)microserviceName) ? qpsControllerMgr.getGlobalQpsStrategy() : qpsControllerMgr.getOrCreate(microserviceName, invocation);
        this.isLimitNewRequest(qpsStrategy, asyncResp);
    }

    private boolean isLimitNewRequest(QpsStrategy qpsStrategy, AsyncResponse asyncResp) {
        if (qpsStrategy.isLimitNewRequest()) {
            CommonExceptionData errorData = new CommonExceptionData("rejected by qps flowcontrol");
            asyncResp.producerFail((Throwable)new InvocationException(QpsConst.TOO_MANY_REQUESTS_STATUS, (Object)errorData));
            return true;
        }
        return false;
    }
}

