/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.qps;

import org.apache.servicecomb.core.Handler;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.qps.Config;
import org.apache.servicecomb.qps.QpsConst;
import org.apache.servicecomb.qps.QpsController;
import org.apache.servicecomb.qps.QpsControllerManager;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.springframework.util.StringUtils;

public class ProviderQpsFlowControlHandler
implements Handler {
    static final QpsControllerManager qpsControllerMgr = new QpsControllerManager().setConfigKeyPrefix("servicecomb.flowcontrol.Provider.qps.limit.").setGlobalQpsController("servicecomb.flowcontrol.Provider.qps.global.limit");

    public void handle(Invocation invocation, AsyncResponse asyncResp) throws Exception {
        if (invocation.getHandlerIndex() > 0) {
            invocation.next(asyncResp);
            return;
        }
        if (!Config.INSTANCE.isProviderEnabled()) {
            return;
        }
        String microserviceName = invocation.getContext("x-cse-src-microservice");
        QpsController qpsController = StringUtils.isEmpty((Object)microserviceName) ? qpsControllerMgr.getGlobalQpsController() : qpsControllerMgr.getOrCreate(microserviceName, invocation);
        this.isLimitNewRequest(qpsController, asyncResp);
    }

    private boolean isLimitNewRequest(QpsController qpsController, AsyncResponse asyncResp) {
        if (qpsController.isLimitNewRequest()) {
            CommonExceptionData errorData = new CommonExceptionData("rejected by qps flowcontrol");
            asyncResp.producerFail((Throwable)new InvocationException(QpsConst.TOO_MANY_REQUESTS_STATUS, (Object)errorData));
            return true;
        }
        return false;
    }
}

