/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.qps;

import java.util.concurrent.atomic.AtomicLong;

public class QpsController {
    private String key;
    private Integer qpsLimit;
    private volatile long msCycleBegin;
    private AtomicLong requestCount = new AtomicLong();
    private volatile long lastRequestCount = 0L;
    private static final int CYCLE_LENGTH = 1000;

    public QpsController(String key, Integer qpsLimit) {
        this.key = key;
        this.qpsLimit = qpsLimit;
        this.msCycleBegin = System.currentTimeMillis();
    }

    public String getKey() {
        return this.key;
    }

    public Integer getQpsLimit() {
        return this.qpsLimit;
    }

    public void setQpsLimit(Integer qpsLimit) {
        this.qpsLimit = qpsLimit;
    }

    public boolean isLimitNewRequest() {
        long newCount = this.requestCount.incrementAndGet();
        long msNow = System.currentTimeMillis();
        if (msNow - this.msCycleBegin > 1000L) {
            this.lastRequestCount = newCount;
            this.msCycleBegin = msNow;
        }
        int limitValue = this.qpsLimit == null ? Integer.MAX_VALUE : this.qpsLimit;
        return newCount - this.lastRequestCount >= (long)limitValue;
    }
}

