/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.test.scaffolding.config;

import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicProperty;
import com.netflix.config.DynamicPropertyFactory;
import java.lang.reflect.Field;
import org.apache.commons.configuration.Configuration;
import org.springframework.util.ReflectionUtils;

public final class ArchaiusUtils {
    private static final Field FIELD_INSTANCE = ReflectionUtils.findField(ConfigurationManager.class, (String)"instance");
    private static final Field FIELD_CUSTOM_CONFIGURATION_INSTALLED = ReflectionUtils.findField(ConfigurationManager.class, (String)"customConfigurationInstalled");
    private static final Field FIELD_CONFIG = ReflectionUtils.findField(DynamicPropertyFactory.class, (String)"config");
    private static final Field FIELD_INITIALIZED_WITH_DEFAULT_CONFIG = ReflectionUtils.findField(DynamicPropertyFactory.class, (String)"initializedWithDefaultConfig");
    private static final Field FIELD_DYNAMIC_PROPERTY_SUPPORTIMPL = ReflectionUtils.findField(DynamicProperty.class, (String)"dynamicPropertySupportImpl");

    private ArchaiusUtils() {
    }

    public static void resetConfig() {
        ReflectionUtils.setField((Field)FIELD_INSTANCE, null, null);
        ReflectionUtils.setField((Field)FIELD_CUSTOM_CONFIGURATION_INSTALLED, null, (Object)false);
        ReflectionUtils.setField((Field)FIELD_CONFIG, null, null);
        ReflectionUtils.setField((Field)FIELD_INITIALIZED_WITH_DEFAULT_CONFIG, null, (Object)false);
        ReflectionUtils.setField((Field)FIELD_DYNAMIC_PROPERTY_SUPPORTIMPL, null, null);
    }

    public static void setProperty(String key, Object value) {
        DynamicPropertyFactory.getInstance();
        Configuration config = (Configuration)DynamicPropertyFactory.getBackingConfigurationSource();
        config.addProperty(key, value);
    }

    static {
        FIELD_INSTANCE.setAccessible(true);
        FIELD_CUSTOM_CONFIGURATION_INSTALLED.setAccessible(true);
        FIELD_CONFIG.setAccessible(true);
        FIELD_INITIALIZED_WITH_DEFAULT_CONFIG.setAccessible(true);
        FIELD_DYNAMIC_PROPERTY_SUPPORTIMPL.setAccessible(true);
    }
}

