/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.strategy.join;

import org.apache.sedona.common.FunctionsGeoTools;
import org.apache.sedona.common.utils.CachedCRSTransformFinder;
import org.apache.sedona.common.utils.GeomUtils;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.operation.MathTransform;

public final class JoinedGeometryRaster$ {
    public static final JoinedGeometryRaster$ MODULE$ = new JoinedGeometryRaster$();

    public Geometry rasterToWGS84Envelope(GridCoverage2D raster) {
        CoordinateReferenceSystem crs = raster.getCoordinateReferenceSystem();
        Envelope2D envelope = raster.getEnvelope2D();
        if (crs == null || crs instanceof DefaultEngineeringCRS) {
            return JTS.toGeometry((BoundingBox)envelope);
        }
        return this.transformToWGS84Envelope((Envelope)envelope, crs);
    }

    public Geometry geometryToWGS84Envelope(Geometry geom) {
        int srid = geom.getSRID();
        if (srid <= 0 || srid == 4326) {
            return geom;
        }
        org.locationtech.jts.geom.Envelope env = geom.getEnvelopeInternal();
        Envelope2D envelope = new Envelope2D(null, env.getMinX(), env.getMinY(), env.getWidth(), env.getHeight());
        CoordinateReferenceSystem crs = FunctionsGeoTools.sridToCRS((int)srid);
        return this.transformToWGS84Envelope((Envelope)envelope, crs);
    }

    private Geometry transformToWGS84Envelope(Envelope envelope, CoordinateReferenceSystem crs) {
        MathTransform transform = CachedCRSTransformFinder.findTransform((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GeneralEnvelope transformedEnvelope = CRS.transform((MathTransform)transform, (Envelope)envelope);
        double minX = transformedEnvelope.getMinimum(0);
        double maxX = transformedEnvelope.getMaximum(0);
        double minY = transformedEnvelope.getMinimum(1);
        double maxY = transformedEnvelope.getMaximum(1);
        org.locationtech.jts.geom.Envelope jtsEnvelope = new org.locationtech.jts.geom.Envelope(minX, maxX, minY, maxY);
        jtsEnvelope.expandBy(jtsEnvelope.getWidth() * 0.1, jtsEnvelope.getHeight() * 0.1);
        Polygon geom = JTS.toGeometry((org.locationtech.jts.geom.Envelope)jtsEnvelope);
        if (crs instanceof GeographicCRS) {
            return geom;
        }
        return GeomUtils.antiMeridianSafeGeom((Geometry)geom);
    }

    private JoinedGeometryRaster$() {
    }
}

