/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.utils;

import java.awt.image.Raster;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.sedona.common.utils.RasterUtils;
import org.geotools.coverage.grid.GridCoverage2D;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.index.strtree.STRtree;

public class RasterInterpolate {
    private RasterInterpolate() {
    }

    public static STRtree generateSTRtree(GridCoverage2D inputRaster, int band) {
        Raster rasterData = inputRaster.getRenderedImage().getData();
        int width = rasterData.getWidth();
        int height = rasterData.getHeight();
        Double noDataValue = RasterUtils.getNoDataValue(inputRaster.getSampleDimension(band));
        GeometryFactory geometryFactory = new GeometryFactory();
        STRtree rtree = new STRtree();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                double value = rasterData.getSampleDouble(x, y, band);
                if (Double.isNaN(value) || value == noDataValue) continue;
                Point point = geometryFactory.createPoint(new Coordinate((double)x, (double)y));
                RasterPoint rasterPoint = new RasterPoint(point, value, 0.0);
                rtree.insert(new Envelope(point.getCoordinate()), (Object)rasterPoint);
            }
        }
        rtree.build();
        return rtree;
    }

    public static double interpolateIDW(int x, int y, STRtree strtree, int width, int height, double power, String mode, Double numPointsOrRadius, Double maxRadiusOrMinPoints) {
        double distance;
        Point point;
        List queryResult;
        GeometryFactory geometryFactory = new GeometryFactory();
        PriorityQueue<RasterPoint> minHeap = new PriorityQueue<RasterPoint>(Comparator.comparingDouble(RasterPoint::getDistance));
        if (mode.equalsIgnoreCase("variable")) {
            Double numPoints = numPointsOrRadius == null ? 12.0 : numPointsOrRadius;
            Double maxRadius = maxRadiusOrMinPoints == null ? Math.sqrt(width * width + height * height) : maxRadiusOrMinPoints;
            queryResult = strtree.query(new Envelope((double)x - maxRadius, (double)x + maxRadius, (double)y - maxRadius, (double)y + maxRadius));
            if (mode.equalsIgnoreCase("variable") && (double)strtree.size() < numPointsOrRadius) {
                throw new IllegalArgumentException("Parameter 'numPoints' defaulted to 12 which is larger than no. of valid pixels within the max search radius. Please choose an appropriate value");
            }
            for (RasterPoint rasterPoint : queryResult) {
                if (!(numPoints <= 0.0)) {
                    point = rasterPoint.getPoint();
                    distance = point.distance((Geometry)geometryFactory.createPoint(new Coordinate((double)x, (double)y)));
                    rasterPoint.setDistance(distance);
                    minHeap.add(rasterPoint);
                    Double d = numPoints;
                    Double d2 = numPoints = Double.valueOf(numPoints - 1.0);
                    continue;
                }
                break;
            }
        } else if (mode.equalsIgnoreCase("fixed")) {
            Double radius = numPointsOrRadius == null ? Math.sqrt(width * width + height * height) : numPointsOrRadius;
            Double minPoints = maxRadiusOrMinPoints == null ? 0.0 : maxRadiusOrMinPoints;
            queryResult = new ArrayList();
            while (true) {
                queryResult.clear();
                Envelope searchEnvelope = new Envelope((double)x - radius, (double)x + radius, (double)y - radius, (double)y + radius);
                queryResult = strtree.query(searchEnvelope);
                if ((double)queryResult.size() >= minPoints) break;
                radius = radius * 1.5;
            }
            for (RasterPoint rasterPoint : queryResult) {
                point = rasterPoint.getPoint();
                distance = point.distance((Geometry)geometryFactory.createPoint(new Coordinate((double)x, (double)y)));
                if (distance <= 0.0 || distance > radius) continue;
                rasterPoint.setDistance(distance);
                minHeap.add(rasterPoint);
            }
        }
        double numerator = 0.0;
        double denominator = 0.0;
        while (!minHeap.isEmpty()) {
            RasterPoint rasterPoint;
            rasterPoint = minHeap.poll();
            double value = rasterPoint.getValue();
            double distance2 = rasterPoint.getDistance();
            double weight = 1.0 / Math.pow(distance2, power);
            numerator += weight * value;
            denominator += weight;
        }
        double interpolatedValue = denominator > 0.0 ? numerator / denominator : Double.NaN;
        return interpolatedValue;
    }

    public static class RasterPoint {
        private Point point;
        private double value;
        private double distance;

        public RasterPoint(Point point, double value, double distance) {
            this.point = point;
            this.value = value;
            this.distance = distance;
        }

        public Point getPoint() {
            return this.point;
        }

        public double getValue() {
            return this.value;
        }

        public double getDistance() {
            return this.distance;
        }

        public void setDistance(double distance) {
            this.distance = distance;
        }
    }
}

