/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.utils;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class CachedCRSTransformFinder {
    private static final LoadingCache<CRSPair, MathTransform> crsTransformCache = Caffeine.newBuilder().maximumSize(1000L).build(CachedCRSTransformFinder::doFindTransform);

    private CachedCRSTransformFinder() {
    }

    public static MathTransform findTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) {
        return (MathTransform)crsTransformCache.get((Object)new CRSPair(sourceCRS, targetCRS));
    }

    private static MathTransform doFindTransform(CRSPair crsPair) throws FactoryException {
        return CRS.findMathTransform((CoordinateReferenceSystem)crsPair.sourceCRS, (CoordinateReferenceSystem)crsPair.targetCRS, (boolean)true);
    }

    private static class CRSPair {
        private final CoordinateReferenceSystem sourceCRS;
        private final CoordinateReferenceSystem targetCRS;
        private final int hashCode;

        public CRSPair(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) {
            this.sourceCRS = sourceCRS;
            this.targetCRS = targetCRS;
            this.hashCode = sourceCRS.hashCode() * 31 + targetCRS.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CRSPair)) {
                return false;
            }
            CRSPair other = (CRSPair)obj;
            return this.sourceCRS == other.sourceCRS && this.targetCRS == other.targetCRS;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

