/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.sphere;

import net.sf.geographiclib.Geodesic;
import net.sf.geographiclib.GeodesicData;
import net.sf.geographiclib.PolygonArea;
import net.sf.geographiclib.PolygonResult;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class Spheroid {
    public static final int EPSG_WORLD_MERCATOR = 3395;
    public static final int EPSG_NORTH_UTM_START = 32601;
    public static final int EPSG_NORTH_UTM_END = 32660;
    public static final int EPSG_NORTH_LAMBERT = 3574;
    public static final int EPSG_NORTH_STEREO = 3995;
    public static final int EPSG_SOUTH_UTM_START = 32701;
    public static final int EPSG_SOUTH_UTM_END = 32760;
    public static final int EPSG_SOUTH_LAMBERT = 3409;
    public static final int EPSG_SOUTH_STEREO = 3031;

    public static double distance(Geometry geom1, Geometry geom2) {
        Coordinate coordinate1 = geom1.getGeometryType().equals("Point") ? geom1.getCoordinate() : geom1.getCentroid().getCoordinate();
        Coordinate coordinate2 = geom2.getGeometryType().equals("Point") ? geom2.getCoordinate() : geom2.getCentroid().getCoordinate();
        double lon1 = coordinate1.getX();
        double lat1 = coordinate1.getY();
        double lon2 = coordinate2.getX();
        double lat2 = coordinate2.getY();
        GeodesicData g = Geodesic.WGS84.Inverse(lat1, lon1, lat2, lon2);
        return g.s12;
    }

    public static double length(Geometry geom) {
        String geomType = geom.getGeometryType();
        if (geomType.equals("Polygon") || geomType.equals("LineString")) {
            PolygonArea p = new PolygonArea(Geodesic.WGS84, true);
            Coordinate[] coordinates = geom.getCoordinates();
            for (int i = 0; i < coordinates.length; ++i) {
                double lon = coordinates[i].getX();
                double lat = coordinates[i].getY();
                p.AddPoint(lat, lon);
            }
            PolygonResult compute = p.Compute();
            return compute.perimeter;
        }
        if (geomType.equals("MultiPolygon") || geomType.equals("MultiLineString") || geomType.equals("GeometryCollection")) {
            double length = 0.0;
            for (int i = 0; i < geom.getNumGeometries(); ++i) {
                length += Spheroid.length(geom.getGeometryN(i));
            }
            return length;
        }
        return 0.0;
    }

    public static double area(Geometry geom) {
        String geomType = geom.getGeometryType();
        if (geomType.equals("Polygon")) {
            PolygonArea p = new PolygonArea(Geodesic.WGS84, false);
            Coordinate[] coordinates = geom.getCoordinates();
            for (int i = 0; i < coordinates.length; ++i) {
                double lon = coordinates[i].getX();
                double lat = coordinates[i].getY();
                p.AddPoint(lat, lon);
            }
            PolygonResult compute = p.Compute();
            return Math.abs(compute.area);
        }
        if (geomType.equals("MultiPolygon") || geomType.equals("GeometryCollection")) {
            double area = 0.0;
            for (int i = 0; i < geom.getNumGeometries(); ++i) {
                area += Spheroid.area(geom.getGeometryN(i));
            }
            return area;
        }
        return 0.0;
    }

    public static Double angularWidth(Envelope envelope) {
        double lon1 = envelope.getMinX();
        double lon2 = envelope.getMaxX();
        double lat = (envelope.getMinY() + envelope.getMaxY()) / 2.0;
        GeodesicData g = Geodesic.WGS84.Inverse(lat, lon1, lat, lon2);
        double distance = g.s12;
        Double angularWidth = Math.toDegrees(distance / (Geodesic.WGS84.EquatorialRadius() * Math.PI / 180.0));
        return angularWidth;
    }

    public static Double angularHeight(Envelope envelope) {
        double lat1 = envelope.getMinY();
        double lat2 = envelope.getMaxY();
        double lon = (envelope.getMinX() + envelope.getMaxX()) / 2.0;
        GeodesicData g = Geodesic.WGS84.Inverse(lat1, lon, lat2, lon);
        double distance = g.s12;
        Double angularHeight = Math.toDegrees(distance / (Geodesic.WGS84.EquatorialRadius() * Math.PI / 180.0));
        return angularHeight;
    }
}

