/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.utils;

import com.sun.media.imageioimpl.common.BogusColorSpace;
import java.awt.Color;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.media.jai.RasterFactory;
import javax.media.jai.RenderedImageAdapter;
import org.apache.sedona.common.FunctionsGeoTools;
import org.apache.sedona.common.raster.RasterAccessors;
import org.geotools.coverage.Category;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.util.ClassChanger;
import org.geotools.util.NumberRange;
import org.locationtech.jts.geom.Geometry;
import org.opengis.coverage.SampleDimensionType;
import org.opengis.geometry.DirectPosition;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

public class RasterUtils {
    private static final GridCoverageFactory gridCoverageFactory = CoverageFactoryFinder.getGridCoverageFactory(null);

    private RasterUtils() {
    }

    public static GridCoverage2D create(WritableRaster raster, GridGeometry2D gridGeometry, GridSampleDimension[] bands) {
        return RasterUtils.create(raster, gridGeometry, bands, null);
    }

    public static GridCoverage2D create(WritableRaster raster, GridGeometry2D gridGeometry, GridSampleDimension[] bands, Double noDataValue) {
        int numBand = raster.getNumBands();
        int rasterDataType = raster.getDataBuffer().getDataType();
        BogusColorSpace cs = new BogusColorSpace(numBand);
        int[] nBits = new int[numBand];
        Arrays.fill(nBits, DataBuffer.getDataTypeSize(rasterDataType));
        ComponentColorModel colorModel = new ComponentColorModel((ColorSpace)cs, nBits, false, true, 1, rasterDataType);
        if (noDataValue != null) {
            GridSampleDimension[] newBands = new GridSampleDimension[numBand];
            for (int k = 0; k < numBand; ++k) {
                newBands[k] = bands != null ? RasterUtils.createSampleDimensionWithNoDataValue(bands[k], (double)noDataValue) : RasterUtils.createSampleDimensionWithNoDataValue("band_" + k, (double)noDataValue);
            }
            bands = newBands;
        }
        BufferedImage image = new BufferedImage(colorModel, raster, false, null);
        return gridCoverageFactory.create((CharSequence)"genericCoverage", (RenderedImage)image, gridGeometry, bands, null, null);
    }

    public static GridCoverage2D create(RenderedImage image, GridGeometry2D gridGeometry, GridSampleDimension[] bands, Double noDataValue) {
        int numBand = image.getSampleModel().getNumBands();
        if (noDataValue != null) {
            GridSampleDimension[] newBands = new GridSampleDimension[numBand];
            for (int k = 0; k < numBand; ++k) {
                newBands[k] = bands != null ? RasterUtils.createSampleDimensionWithNoDataValue(bands[k], (double)noDataValue) : RasterUtils.createSampleDimensionWithNoDataValue("band_" + k, (double)noDataValue);
            }
            bands = newBands;
        }
        return gridCoverageFactory.create((CharSequence)"genericCoverage", image, gridGeometry, bands, null, null);
    }

    public static GridSampleDimension createSampleDimensionWithNoDataValue(GridSampleDimension sampleDimension, double noDataValue) {
        double existingNoDataValue = RasterUtils.getNoDataValue(sampleDimension);
        if (Double.compare(existingNoDataValue, noDataValue) == 0) {
            return sampleDimension;
        }
        String description = sampleDimension.getDescription().toString();
        List categories = sampleDimension.getCategories();
        double offset = sampleDimension.getOffset();
        double scale = sampleDimension.getScale();
        ArrayList<Category> newCategories = new ArrayList<Category>(categories.size());
        for (Category category : categories) {
            NumberRange range = category.getRange();
            if (range.contains((Number)noDataValue)) {
                Number min = (Number)((Object)range.getMinValue());
                Number max = (Number)((Object)range.getMaxValue());
                Class clazz = ClassChanger.getWidestClass((Number)min, (Number)max);
                min = ClassChanger.cast((Number)min, (Class)clazz);
                max = ClassChanger.cast((Number)max, (Class)clazz);
                Number nodata = ClassChanger.cast((Number)noDataValue, (Class)clazz);
                if (min.doubleValue() < noDataValue) {
                    Category leftCategory = new Category((CharSequence)category.getName(), category.getColors(), new NumberRange(clazz, min, range.isMinIncluded(), nodata, false));
                    newCategories.add(leftCategory);
                }
                if (!(max.doubleValue() > noDataValue)) continue;
                Category rightCategory = new Category((CharSequence)category.getName(), category.getColors(), new NumberRange(clazz, nodata, false, max, range.isMaxIncluded()));
                newCategories.add(rightCategory);
                continue;
            }
            if (category.getName().equals(Category.NODATA.getName())) continue;
            newCategories.add(category);
        }
        Number nodata = TypeMap.wrapSample((double)noDataValue, (SampleDimensionType)sampleDimension.getSampleDimensionType(), (boolean)false);
        newCategories.add(new Category((CharSequence)Category.NODATA.getName(), new Color(0, 0, 0, 0), new NumberRange(nodata.getClass(), nodata, nodata)));
        return new GridSampleDimension(description, newCategories.toArray(new Category[0]), offset, scale);
    }

    public static GridSampleDimension createSampleDimensionWithNoDataValue(String description, double noDataValue) {
        Category noDataCategory = new Category((CharSequence)Category.NODATA.getName(), new Color(0, 0, 0, 0), new NumberRange(Double.class, (Number)noDataValue, (Number)noDataValue));
        Category[] categories = new Category[]{noDataCategory};
        return new GridSampleDimension((CharSequence)description, categories, null);
    }

    public static GridSampleDimension removeNoDataValue(GridSampleDimension sampleDimension) {
        String description = sampleDimension.getDescription().toString();
        List categories = sampleDimension.getCategories();
        ArrayList<Category> newCategories = new ArrayList<Category>(categories.size());
        InternationalString noDataCategoryName = Category.NODATA.getName();
        for (Category category : categories) {
            if (category.getName().equals(noDataCategoryName)) continue;
            newCategories.add(category);
        }
        if (newCategories.size() == categories.size()) {
            return sampleDimension;
        }
        double offset = sampleDimension.getOffset();
        double scale = sampleDimension.getScale();
        return new GridSampleDimension(description, newCategories.toArray(new Category[0]), offset, scale);
    }

    public static double getNoDataValue(GridSampleDimension sampleDimension) {
        List categories = sampleDimension.getCategories();
        InternationalString noDataCategoryName = Category.NODATA.getName();
        for (Category category : categories) {
            if (!category.getName().equals(noDataCategoryName)) continue;
            return category.getRange().getMinimum();
        }
        return Double.NaN;
    }

    public static AffineTransform2D getGDALAffineTransform(GridCoverage2D raster) {
        return RasterUtils.getAffineTransform(raster, PixelOrientation.UPPER_LEFT);
    }

    public static AffineTransform2D getAffineTransform(GridCoverage2D raster, PixelOrientation orientation) throws UnsupportedOperationException {
        GridGeometry2D gridGeometry2D = raster.getGridGeometry();
        MathTransform2D crsTransform = gridGeometry2D.getGridToCRS2D(orientation);
        if (!(crsTransform instanceof AffineTransform2D)) {
            throw new UnsupportedOperationException("Only AffineTransform2D is supported");
        }
        return (AffineTransform2D)crsTransform;
    }

    public static Point2D getWorldCornerCoordinates(GridCoverage2D raster, int colX, int rowY) throws TransformException {
        return raster.getGridGeometry().getGridToCRS2D(PixelOrientation.UPPER_LEFT).transform((Point2D)new GridCoordinates2D(colX - 1, rowY - 1), null);
    }

    public static Point2D getWorldCornerCoordinatesWithRangeCheck(GridCoverage2D raster, int colX, int rowY) throws IndexOutOfBoundsException, TransformException {
        GridCoordinates2D gridCoordinates2D = new GridCoordinates2D(colX - 1, rowY - 1);
        if (!raster.getGridGeometry().getGridRange2D().contains((Point)gridCoordinates2D)) {
            throw new IndexOutOfBoundsException(String.format("Specified pixel coordinates (%d, %d) do not lie in the raster", colX, rowY));
        }
        return raster.getGridGeometry().getGridToCRS2D(PixelOrientation.UPPER_LEFT).transform((Point2D)gridCoordinates2D, null);
    }

    public static int[] getGridCoordinatesFromWorld(GridCoverage2D raster, double longitude, double latitude) throws TransformException {
        DirectPosition2D directPosition2D = new DirectPosition2D(raster.getCoordinateReferenceSystem2D(), longitude, latitude);
        DirectPosition worldCoord = raster.getGridGeometry().getCRSToGrid2D(PixelOrientation.UPPER_LEFT).transform((DirectPosition)directPosition2D, null);
        double[] coords = worldCoord.getCoordinate();
        int[] gridCoords = new int[]{(int)Math.floor(coords[0]), (int)Math.floor(coords[1])};
        return gridCoords;
    }

    public static void ensureBand(GridCoverage2D raster, int band) throws IllegalArgumentException {
        if (band < 1 || band > RasterAccessors.numBands(raster)) {
            throw new IllegalArgumentException(String.format("Provided band index %d is not present in the raster", band));
        }
    }

    public static Raster getRaster(RenderedImage renderedImage) {
        while (renderedImage instanceof RenderedImageAdapter) {
            renderedImage = ((RenderedImageAdapter)renderedImage).getWrappedImage();
        }
        if (renderedImage instanceof BufferedImage) {
            return ((BufferedImage)renderedImage).getRaster();
        }
        return renderedImage.getData();
    }

    public static Geometry convertCRSIfNeeded(Geometry geometry, CoordinateReferenceSystem targetCRS) {
        int geomSRID = geometry.getSRID();
        if (targetCRS != null && !(targetCRS instanceof DefaultEngineeringCRS) && geomSRID > 0) {
            try {
                geometry = FunctionsGeoTools.transformToGivenTarget(geometry, null, targetCRS, true);
            }
            catch (FactoryException | TransformException e) {
                throw new RuntimeException("Cannot transform CRS of query window", e);
            }
        }
        return geometry;
    }

    public static int getDataTypeCode(String s) {
        switch (s.toLowerCase()) {
            case "d": {
                return 5;
            }
            case "i": {
                return 3;
            }
            case "b": {
                return 0;
            }
            case "f": {
                return 4;
            }
            case "s": {
                return 2;
            }
            case "us": {
                return 1;
            }
        }
        return 5;
    }

    public static boolean isDataTypeIntegral(int dataTypeCode) {
        switch (dataTypeCode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public static GridCoverage2D copyRasterAndAppendBand(GridCoverage2D gridCoverage2D, Number[] bandValues, Double noDataValue) {
        RenderedImage originalImage = gridCoverage2D.getRenderedImage();
        Raster raster = RasterUtils.getRaster(originalImage);
        Point location = raster.getBounds().getLocation();
        WritableRaster wr = RasterFactory.createBandedRaster((int)raster.getDataBuffer().getDataType(), (int)originalImage.getWidth(), (int)originalImage.getHeight(), (int)(gridCoverage2D.getNumSampleDimensions() + 1), (Point)location);
        for (int i = 0; i < raster.getWidth(); ++i) {
            for (int j = 0; j < raster.getHeight(); ++j) {
                Object[] copiedPixels;
                Object[] pixels;
                if (bandValues instanceof Double[]) {
                    pixels = raster.getPixel(i, j, (double[])null);
                    copiedPixels = new double[pixels.length + 1];
                    System.arraycopy(pixels, 0, copiedPixels, 0, pixels.length);
                    copiedPixels[pixels.length] = (Double)bandValues[j * raster.getWidth() + i];
                    wr.setPixel(i, j, (double[])copiedPixels);
                    continue;
                }
                if (!(bandValues instanceof Integer[])) continue;
                pixels = raster.getPixel(i, j, (int[])null);
                copiedPixels = new int[pixels.length + 1];
                System.arraycopy(pixels, 0, copiedPixels, 0, pixels.length);
                copiedPixels[pixels.length] = ((Integer)bandValues[j * raster.getWidth() + i]).intValue();
                wr.setPixel(i, j, (int[])copiedPixels);
            }
        }
        int numBand = wr.getNumBands();
        GridSampleDimension[] originalSampleDimensions = gridCoverage2D.getSampleDimensions();
        GridSampleDimension[] sampleDimensions = new GridSampleDimension[numBand];
        System.arraycopy(originalSampleDimensions, 0, sampleDimensions, 0, originalSampleDimensions.length);
        sampleDimensions[numBand - 1] = noDataValue != null ? RasterUtils.createSampleDimensionWithNoDataValue("band" + numBand, (double)noDataValue) : new GridSampleDimension((CharSequence)("band" + numBand));
        return RasterUtils.create(wr, gridCoverage2D.getGridGeometry(), sampleDimensions);
    }

    public static GridCoverage2D copyRasterAndAppendBand(GridCoverage2D gridCoverage2D, Number[] bandValues) {
        return RasterUtils.copyRasterAndAppendBand(gridCoverage2D, bandValues, null);
    }

    public static GridCoverage2D copyRasterAndReplaceBand(GridCoverage2D gridCoverage2D, int bandIndex, Number[] bandValues, Double noDataValue, boolean removeNoDataIfNull) {
        RasterUtils.ensureBand(gridCoverage2D, bandIndex);
        RenderedImage originalImage = gridCoverage2D.getRenderedImage();
        Raster raster = RasterUtils.getRaster(originalImage);
        WritableRaster wr = raster.createCompatibleWritableRaster();
        for (int i = 0; i < raster.getWidth(); ++i) {
            for (int j = 0; j < raster.getHeight(); ++j) {
                Object[] bands;
                if (bandValues instanceof Double[]) {
                    bands = raster.getPixel(i, j, (double[])null);
                    bands[bandIndex - 1] = (Double)bandValues[j * raster.getWidth() + i];
                    wr.setPixel(i, j, (double[])bands);
                    continue;
                }
                if (!(bandValues instanceof Integer[])) continue;
                bands = raster.getPixel(i, j, (int[])null);
                bands[bandIndex - 1] = ((Integer)bandValues[j * raster.getWidth() + i]).intValue();
                wr.setPixel(i, j, (int[])bands);
            }
        }
        GridSampleDimension[] sampleDimensions = gridCoverage2D.getSampleDimensions();
        GridSampleDimension sampleDimension = sampleDimensions[bandIndex - 1];
        if (noDataValue == null && removeNoDataIfNull) {
            sampleDimensions[bandIndex - 1] = RasterUtils.removeNoDataValue(sampleDimension);
        } else if (noDataValue != null) {
            sampleDimensions[bandIndex - 1] = RasterUtils.createSampleDimensionWithNoDataValue(sampleDimension, (double)noDataValue);
        }
        return RasterUtils.create(wr, gridCoverage2D.getGridGeometry(), sampleDimensions);
    }

    public static GridCoverage2D copyRasterAndReplaceBand(GridCoverage2D gridCoverage2D, int bandIndex, Number[] bandValues) {
        return RasterUtils.copyRasterAndReplaceBand(gridCoverage2D, bandIndex, bandValues, null, false);
    }
}

