/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.raster;

import java.util.Arrays;
import java.util.Set;
import org.apache.sedona.common.utils.RasterUtils;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class RasterAccessors {
    public static int srid(GridCoverage2D raster) throws FactoryException {
        CoordinateReferenceSystem crs = raster.getCoordinateReferenceSystem();
        if (crs instanceof DefaultEngineeringCRS && ((DefaultEngineeringCRS)crs).isWildcard()) {
            return 0;
        }
        Set crsIds = crs.getIdentifiers();
        if (crsIds.isEmpty()) {
            return 0;
        }
        for (ReferenceIdentifier crsId : crsIds) {
            if (!"EPSG".equals(crsId.getCodeSpace())) continue;
            return Integer.parseInt(crsId.getCode());
        }
        return 0;
    }

    public static int numBands(GridCoverage2D raster) {
        return raster.getNumSampleDimensions();
    }

    public static int getWidth(GridCoverage2D raster) {
        return raster.getGridGeometry().getGridRange().getSpan(0);
    }

    public static int getHeight(GridCoverage2D raster) {
        return raster.getGridGeometry().getGridRange().getSpan(1);
    }

    public static double getUpperLeftX(GridCoverage2D raster) {
        AffineTransform2D affine = RasterUtils.getGDALAffineTransform(raster);
        return affine.getTranslateX();
    }

    public static double getUpperLeftY(GridCoverage2D raster) {
        AffineTransform2D affine = RasterUtils.getGDALAffineTransform(raster);
        return affine.getTranslateY();
    }

    public static double getScaleX(GridCoverage2D raster) {
        return RasterUtils.getGDALAffineTransform(raster).getScaleX();
    }

    public static double getScaleY(GridCoverage2D raster) {
        return RasterUtils.getGDALAffineTransform(raster).getScaleY();
    }

    public static double getSkewX(GridCoverage2D raster) {
        return RasterUtils.getGDALAffineTransform(raster).getShearX();
    }

    public static double getSkewY(GridCoverage2D raster) {
        return RasterUtils.getGDALAffineTransform(raster).getShearY();
    }

    public static double getWorldCoordX(GridCoverage2D raster, int colX, int rowY) throws TransformException {
        return RasterUtils.getWorldCornerCoordinates(raster, colX, rowY).getX();
    }

    public static double getWorldCoordY(GridCoverage2D raster, int colX, int rowY) throws TransformException {
        return RasterUtils.getWorldCornerCoordinates(raster, colX, rowY).getY();
    }

    public static String getGeoReference(GridCoverage2D raster) {
        return RasterAccessors.getGeoReference(raster, "GDAL");
    }

    public static String getGeoReference(GridCoverage2D raster, String format) {
        double scaleX = RasterAccessors.getScaleX(raster);
        double skewX = RasterAccessors.getSkewX(raster);
        double skewY = RasterAccessors.getSkewY(raster);
        double scaleY = RasterAccessors.getScaleY(raster);
        double upperLeftX = RasterAccessors.getUpperLeftX(raster);
        double upperLeftY = RasterAccessors.getUpperLeftY(raster);
        if (format.equalsIgnoreCase("GDAL")) {
            return String.format("%f \n%f \n%f \n%f \n%f \n%f", scaleX, skewY, skewX, scaleY, upperLeftX, upperLeftY);
        }
        if (format.equalsIgnoreCase("ESRI")) {
            return String.format("%f \n%f \n%f \n%f \n%f \n%f", scaleX, skewY, skewX, scaleY, upperLeftX + scaleX * 0.5, upperLeftY + scaleY * 0.5);
        }
        throw new IllegalArgumentException("Please select between the following formats GDAL and ESRI");
    }

    public static Geometry getGridCoord(GridCoverage2D raster, double x, double y) throws TransformException {
        int[] coords = RasterUtils.getGridCoordinatesFromWorld(raster, x, y);
        coords = Arrays.stream(coords).map(number -> number + 1).toArray();
        Point point = new GeometryFactory().createPoint(new Coordinate((double)coords[0], (double)coords[1]));
        return point;
    }

    public static Geometry getGridCoord(GridCoverage2D raster, Geometry point) throws TransformException {
        RasterAccessors.ensurePoint(point);
        point = RasterUtils.convertCRSIfNeeded(point, raster.getCoordinateReferenceSystem2D());
        Point actualPoint = (Point)point;
        return RasterAccessors.getGridCoord(raster, actualPoint.getX(), actualPoint.getY());
    }

    public static int getGridCoordX(GridCoverage2D raster, double x, double y) throws TransformException {
        return RasterUtils.getGridCoordinatesFromWorld(raster, x, y)[0] + 1;
    }

    public static int getGridCoordX(GridCoverage2D raster, Geometry point) throws TransformException {
        RasterAccessors.ensurePoint(point);
        point = RasterUtils.convertCRSIfNeeded(point, raster.getCoordinateReferenceSystem2D());
        Point actualPoint = (Point)point;
        return RasterAccessors.getGridCoordX(raster, actualPoint.getX(), actualPoint.getY());
    }

    public static int getGridCoordY(GridCoverage2D raster, double x, double y) throws TransformException {
        return RasterUtils.getGridCoordinatesFromWorld(raster, x, y)[1] + 1;
    }

    public static int getGridCoordY(GridCoverage2D raster, Geometry point) throws TransformException {
        RasterAccessors.ensurePoint(point);
        point = RasterUtils.convertCRSIfNeeded(point, raster.getCoordinateReferenceSystem2D());
        Point actualPoint = (Point)point;
        return RasterAccessors.getGridCoordY(raster, actualPoint.getX(), actualPoint.getY());
    }

    private static void ensurePoint(Geometry geometry) throws IllegalArgumentException {
        if (!(geometry instanceof Point)) {
            throw new IllegalArgumentException("Only point geometries are expected as real world coordinates");
        }
    }

    public static double[] metadata(GridCoverage2D raster) throws FactoryException {
        GridEnvelope2D gridRange = raster.getGridGeometry().getGridRange2D();
        AffineTransform2D affine = RasterUtils.getGDALAffineTransform(raster);
        double upperLeftX = affine.getTranslateX();
        double upperLeftY = affine.getTranslateY();
        double scaleX = affine.getScaleX();
        double scaleY = affine.getScaleY();
        double skewX = affine.getShearX();
        double skewY = affine.getShearY();
        return new double[]{upperLeftX, upperLeftY, gridRange.getWidth(), gridRange.getHeight(), scaleX, scaleY, skewX, skewY, RasterAccessors.srid(raster), raster.getNumSampleDimensions()};
    }
}

