/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.raster;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.sedona.common.raster.RasterAccessors;
import org.apache.sedona.common.utils.RasterUtils;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.geometry.DirectPosition2D;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.opengis.coverage.PointOutsideCoverageException;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.TransformException;

public class PixelFunctions {
    private static GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();

    public static Double value(GridCoverage2D rasterGeom, Geometry geometry, int band) throws TransformException {
        return PixelFunctions.values(rasterGeom, Collections.singletonList(geometry), band).get(0);
    }

    public static Geometry getPixelAsPolygon(GridCoverage2D raster, int colX, int rowY) throws TransformException, FactoryException {
        int srid = RasterAccessors.srid(raster);
        Point2D point2D1 = RasterUtils.getWorldCornerCoordinates(raster, colX, rowY);
        Point2D point2D2 = RasterUtils.getWorldCornerCoordinates(raster, colX + 1, rowY);
        Point2D point2D3 = RasterUtils.getWorldCornerCoordinates(raster, colX + 1, rowY + 1);
        Point2D point2D4 = RasterUtils.getWorldCornerCoordinates(raster, colX, rowY + 1);
        Coordinate[] coordinateArray = new Coordinate[]{new Coordinate(point2D1.getX(), point2D1.getY()), new Coordinate(point2D2.getX(), point2D2.getY()), new Coordinate(point2D3.getX(), point2D3.getY()), new Coordinate(point2D4.getX(), point2D4.getY()), new Coordinate(point2D1.getX(), point2D1.getY())};
        if (srid != 0) {
            GeometryFactory factory = new GeometryFactory(new PrecisionModel(), srid);
            return factory.createPolygon(coordinateArray);
        }
        return GEOMETRY_FACTORY.createPolygon(coordinateArray);
    }

    public static Geometry getPixelAsCentroid(GridCoverage2D raster, int colX, int rowY) throws FactoryException, TransformException {
        Geometry polygon = PixelFunctions.getPixelAsPolygon(raster, colX, rowY);
        return polygon.getCentroid();
    }

    public static Geometry getPixelAsPoint(GridCoverage2D raster, int colX, int rowY) throws TransformException, FactoryException {
        int srid = RasterAccessors.srid(raster);
        Point2D point2D = RasterUtils.getWorldCornerCoordinatesWithRangeCheck(raster, colX, rowY);
        Coordinate pointCoord = new Coordinate(point2D.getX(), point2D.getY());
        if (srid != 0) {
            GeometryFactory factory = new GeometryFactory(new PrecisionModel(), srid);
            return factory.createPoint(pointCoord);
        }
        return GEOMETRY_FACTORY.createPoint(pointCoord);
    }

    public static List<Double> values(GridCoverage2D rasterGeom, List<Geometry> geometries, int band) throws TransformException {
        int numBands = rasterGeom.getNumSampleDimensions();
        if (band < 1 || band > numBands) {
            return geometries.stream().map(geom -> null).collect(Collectors.toList());
        }
        double noDataValue = RasterUtils.getNoDataValue(rasterGeom.getSampleDimension(band - 1));
        double[] pixelBuffer = new double[numBands];
        ArrayList<Double> result = new ArrayList<Double>(geometries.size());
        for (Geometry geom2 : geometries) {
            if (geom2 == null) {
                result.add(null);
                continue;
            }
            Point point = PixelFunctions.ensurePoint(geom2);
            DirectPosition2D directPosition2D = new DirectPosition2D(point.getX(), point.getY());
            try {
                rasterGeom.evaluate((DirectPosition)directPosition2D, pixelBuffer);
                double pixel = pixelBuffer[band - 1];
                if (Double.compare(noDataValue, pixel) == 0) {
                    result.add(null);
                    continue;
                }
                result.add(pixel);
            }
            catch (ArrayIndexOutOfBoundsException | PointOutsideCoverageException exc) {
                result.add(null);
            }
        }
        return result;
    }

    private static Point ensurePoint(Geometry geometry) {
        if (geometry instanceof Point) {
            return (Point)geometry;
        }
        throw new IllegalArgumentException("Attempting to get the value of a pixel with a non-point geometry.");
    }
}

