/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.oceanbase;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Optional;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.utils.BufferUtils;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.converter.AbstractJdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.utils.JdbcFieldTypeUtils;

public class OceanBaseMysqlJdbcRowConverter
extends AbstractJdbcRowConverter {
    @Override
    public String converterName() {
        return "OceanBase";
    }

    @Override
    protected void writeTime(PreparedStatement statement, int index, LocalTime time) throws SQLException {
        statement.setTimestamp(index, Timestamp.valueOf(LocalDateTime.of(LocalDate.now(), time)));
    }

    @Override
    public SeaTunnelRow toInternal(ResultSet rs, TableSchema tableSchema) throws SQLException {
        SeaTunnelRowType typeInfo = tableSchema.toPhysicalRowDataType();
        Object[] fields = new Object[typeInfo.getTotalFields()];
        block18: for (int fieldIndex = 0; fieldIndex < typeInfo.getTotalFields(); ++fieldIndex) {
            SeaTunnelDataType seaTunnelDataType = typeInfo.getFieldType(fieldIndex);
            String fieldName = typeInfo.getFieldName(fieldIndex);
            int resultSetIndex = fieldIndex + 1;
            switch (seaTunnelDataType.getSqlType()) {
                case STRING: {
                    fields[fieldIndex] = JdbcFieldTypeUtils.getString(rs, resultSetIndex);
                    continue block18;
                }
                case BOOLEAN: {
                    fields[fieldIndex] = JdbcFieldTypeUtils.getBoolean(rs, resultSetIndex);
                    continue block18;
                }
                case TINYINT: {
                    fields[fieldIndex] = JdbcFieldTypeUtils.getByte(rs, resultSetIndex);
                    continue block18;
                }
                case SMALLINT: {
                    fields[fieldIndex] = JdbcFieldTypeUtils.getShort(rs, resultSetIndex);
                    continue block18;
                }
                case INT: {
                    fields[fieldIndex] = JdbcFieldTypeUtils.getInt(rs, resultSetIndex);
                    continue block18;
                }
                case BIGINT: {
                    fields[fieldIndex] = JdbcFieldTypeUtils.getLong(rs, resultSetIndex);
                    continue block18;
                }
                case FLOAT: {
                    fields[fieldIndex] = JdbcFieldTypeUtils.getFloat(rs, resultSetIndex);
                    continue block18;
                }
                case FLOAT_VECTOR: {
                    Object[] objects = (Object[])rs.getObject(fieldIndex);
                    Float[] arrays = new Float[objects.length];
                    for (int i = 0; i < objects.length; ++i) {
                        arrays[i] = Float.valueOf(Float.parseFloat(objects[i].toString()));
                    }
                    fields[fieldIndex] = BufferUtils.toByteBuffer((Float[])arrays);
                    continue block18;
                }
                case DOUBLE: {
                    fields[fieldIndex] = JdbcFieldTypeUtils.getDouble(rs, resultSetIndex);
                    continue block18;
                }
                case DECIMAL: {
                    fields[fieldIndex] = JdbcFieldTypeUtils.getBigDecimal(rs, resultSetIndex);
                    continue block18;
                }
                case DATE: {
                    Date sqlDate = JdbcFieldTypeUtils.getDate(rs, resultSetIndex);
                    fields[fieldIndex] = Optional.ofNullable(sqlDate).map(e -> e.toLocalDate()).orElse(null);
                    continue block18;
                }
                case TIME: {
                    fields[fieldIndex] = this.readTime(rs, resultSetIndex);
                    continue block18;
                }
                case TIMESTAMP: {
                    Timestamp sqlTimestamp = JdbcFieldTypeUtils.getTimestamp(rs, resultSetIndex);
                    fields[fieldIndex] = Optional.ofNullable(sqlTimestamp).map(e -> e.toLocalDateTime()).orElse(null);
                    continue block18;
                }
                case BYTES: {
                    fields[fieldIndex] = JdbcFieldTypeUtils.getBytes(rs, resultSetIndex);
                    continue block18;
                }
                case NULL: {
                    fields[fieldIndex] = null;
                    continue block18;
                }
                case ARRAY: {
                    fields[fieldIndex] = this.convertToArray(rs, resultSetIndex, seaTunnelDataType, fieldName);
                    continue block18;
                }
                default: {
                    throw CommonError.unsupportedDataType((String)this.converterName(), (String)seaTunnelDataType.getSqlType().toString(), (String)fieldName);
                }
            }
        }
        return new SeaTunnelRow(fields);
    }

    @Override
    public PreparedStatement toExternal(TableSchema tableSchema, SeaTunnelRow row, PreparedStatement statement) throws SQLException {
        SeaTunnelRowType rowType = tableSchema.toPhysicalRowDataType();
        block20: for (int fieldIndex = 0; fieldIndex < rowType.getTotalFields(); ++fieldIndex) {
            try {
                SeaTunnelDataType seaTunnelDataType = rowType.getFieldType(fieldIndex);
                int statementIndex = fieldIndex + 1;
                Object fieldValue = row.getField(fieldIndex);
                if (fieldValue == null) {
                    statement.setObject(statementIndex, null);
                    continue;
                }
                switch (seaTunnelDataType.getSqlType()) {
                    case STRING: {
                        statement.setString(statementIndex, (String)row.getField(fieldIndex));
                        break;
                    }
                    case BOOLEAN: {
                        statement.setBoolean(statementIndex, (Boolean)row.getField(fieldIndex));
                        break;
                    }
                    case TINYINT: {
                        statement.setByte(statementIndex, (Byte)row.getField(fieldIndex));
                        break;
                    }
                    case SMALLINT: {
                        statement.setShort(statementIndex, (Short)row.getField(fieldIndex));
                        break;
                    }
                    case INT: {
                        statement.setInt(statementIndex, (Integer)row.getField(fieldIndex));
                        break;
                    }
                    case BIGINT: {
                        statement.setLong(statementIndex, (Long)row.getField(fieldIndex));
                        break;
                    }
                    case FLOAT: {
                        statement.setFloat(statementIndex, ((Float)row.getField(fieldIndex)).floatValue());
                        break;
                    }
                    case FLOAT_VECTOR: {
                        if (!(row.getField(fieldIndex) instanceof ByteBuffer)) continue block20;
                        ByteBuffer byteBuffer = (ByteBuffer)row.getField(fieldIndex);
                        Float[] floatArray = BufferUtils.toFloatArray((ByteBuffer)byteBuffer);
                        StringBuilder vector = new StringBuilder();
                        vector.append("[");
                        for (Float aFloat : floatArray) {
                            vector.append(aFloat).append(", ");
                        }
                        if (vector.length() > 0) {
                            vector.setLength(vector.length() - 2);
                        }
                        vector.append("]");
                        statement.setString(statementIndex, vector.toString());
                        break;
                    }
                    case DOUBLE: {
                        statement.setDouble(statementIndex, (Double)row.getField(fieldIndex));
                        break;
                    }
                    case DECIMAL: {
                        statement.setBigDecimal(statementIndex, (BigDecimal)row.getField(fieldIndex));
                        break;
                    }
                    case DATE: {
                        LocalDate localDate = (LocalDate)row.getField(fieldIndex);
                        statement.setDate(statementIndex, Date.valueOf(localDate));
                        break;
                    }
                    case TIME: {
                        this.writeTime(statement, statementIndex, (LocalTime)row.getField(fieldIndex));
                        break;
                    }
                    case TIMESTAMP: {
                        LocalDateTime localDateTime = (LocalDateTime)row.getField(fieldIndex);
                        statement.setTimestamp(statementIndex, Timestamp.valueOf(localDateTime));
                        break;
                    }
                    case BYTES: {
                        statement.setBytes(statementIndex, (byte[])row.getField(fieldIndex));
                        break;
                    }
                    case NULL: {
                        statement.setNull(statementIndex, 0);
                        break;
                    }
                    case ARRAY: {
                        SeaTunnelDataType elementType = ((ArrayType)seaTunnelDataType).getElementType();
                        Object[] array = (Object[])row.getField(fieldIndex);
                        if (array == null) {
                            statement.setNull(statementIndex, 2003);
                            break;
                        }
                        if (SqlType.TINYINT.equals((Object)elementType.getSqlType())) {
                            Short[] shortArray = new Short[array.length];
                            for (int i = 0; i < array.length; ++i) {
                                shortArray[i] = Short.valueOf(array[i].toString());
                            }
                            statement.setObject(statementIndex, shortArray);
                            break;
                        }
                        statement.setObject(statementIndex, array);
                        break;
                    }
                    default: {
                        throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, "Unexpected value: " + seaTunnelDataType);
                    }
                }
                continue;
            }
            catch (Exception e) {
                throw new JdbcConnectorException(JdbcConnectorErrorCode.DATA_TYPE_CAST_FAILED, "error field:" + rowType.getFieldNames()[fieldIndex], e);
            }
        }
        return statement;
    }
}

