/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.dm;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.api.table.converter.TypeConverter;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.connectors.seatunnel.common.source.TypeDefineUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={TypeConverter.class})
public class DmdbTypeConverter
implements TypeConverter<BasicTypeDefine> {
    private static final Logger log = LoggerFactory.getLogger(DmdbTypeConverter.class);
    public static final String DM_BIT = "BIT";
    public static final String DM_INTEGER = "INTEGER";
    public static final String DM_INT = "INT";
    public static final String DM_PLS_INTEGER = "PLS_INTEGER";
    public static final String DM_BIGINT = "BIGINT";
    public static final String DM_TINYINT = "TINYINT";
    public static final String DM_BYTE = "BYTE";
    public static final String DM_SMALLINT = "SMALLINT";
    public static final String DM_FLOAT = "FLOAT";
    public static final String DM_DOUBLE = "DOUBLE";
    public static final String DM_DOUBLE_PRECISION = "DOUBLE PRECISION";
    public static final String DM_REAL = "REAL";
    public static final String DM_NUMERIC = "NUMERIC";
    public static final String DM_NUMBER = "NUMBER";
    public static final String DM_DECIMAL = "DECIMAL";
    public static final String DM_DEC = "DEC";
    public static final String DM_CHAR = "CHAR";
    public static final String DM_CHARACTER = "CHARACTER";
    public static final String DM_VARCHAR = "VARCHAR";
    public static final String DM_VARCHAR2 = "VARCHAR2";
    public static final String DM_LONGVARCHAR = "LONGVARCHAR";
    public static final String DM_CLOB = "CLOB";
    public static final String DM_TEXT = "TEXT";
    public static final String DM_LONG = "LONG";
    public static final String DM_BINARY = "BINARY";
    public static final String DM_VARBINARY = "VARBINARY";
    public static final String DM_BLOB = "BLOB";
    public static final String DM_BFILE = "BFILE";
    public static final String DM_IMAGE = "IMAGE";
    public static final String DM_LONGVARBINARY = "LONGVARBINARY";
    public static final String DM_DATE = "DATE";
    public static final String DM_TIME = "TIME";
    public static final String DM_TIME_WITH_TIME_ZONE = "TIME WITH TIME ZONE";
    public static final String DM_TIMESTAMP = "TIMESTAMP";
    public static final String DM_DATETIME = "DATETIME";
    public static final String DM_DATETIME_WITH_TIME_ZONE = "DATETIME WITH TIME ZONE";
    public static final int DEFAULT_PRECISION = 38;
    public static final int MAX_PRECISION = 38;
    public static final int DEFAULT_SCALE = 18;
    public static final int MAX_SCALE = 37;
    public static final int MAX_TIME_SCALE = 6;
    public static final int MAX_TIMESTAMP_SCALE = 6;
    public static final long MAX_CHAR_LENGTH_FOR_PAGE_4K = 1900L;
    public static final long MAX_BINARY_LENGTH_FOR_PAGE_4K = 1900L;
    public static final DmdbTypeConverter INSTANCE = new DmdbTypeConverter();

    public String identifier() {
        return "Dameng";
    }

    public Column convert(BasicTypeDefine typeDefine) {
        String dmType;
        PhysicalColumn.PhysicalColumnBuilder builder = PhysicalColumn.builder().name(typeDefine.getName()).nullable(typeDefine.isNullable()).defaultValue(typeDefine.getDefaultValue()).comment(typeDefine.getComment());
        switch (dmType = typeDefine.getDataType().toUpperCase()) {
            case "BIT": {
                builder.sourceType(DM_BIT);
                builder.dataType((SeaTunnelDataType)BasicType.BOOLEAN_TYPE);
                break;
            }
            case "TINYINT": {
                builder.sourceType(DM_TINYINT);
                builder.dataType((SeaTunnelDataType)BasicType.BYTE_TYPE);
                break;
            }
            case "BYTE": {
                builder.sourceType(DM_BYTE);
                builder.dataType((SeaTunnelDataType)BasicType.BYTE_TYPE);
                break;
            }
            case "SMALLINT": {
                builder.sourceType(DM_SMALLINT);
                builder.dataType((SeaTunnelDataType)BasicType.SHORT_TYPE);
                break;
            }
            case "INT": {
                builder.sourceType(DM_INT);
                builder.dataType((SeaTunnelDataType)BasicType.INT_TYPE);
                break;
            }
            case "INTEGER": {
                builder.sourceType(DM_INTEGER);
                builder.dataType((SeaTunnelDataType)BasicType.INT_TYPE);
                break;
            }
            case "PLS_INTEGER": {
                builder.sourceType(DM_PLS_INTEGER);
                builder.dataType((SeaTunnelDataType)BasicType.INT_TYPE);
                break;
            }
            case "BIGINT": {
                builder.sourceType(DM_BIGINT);
                builder.dataType((SeaTunnelDataType)BasicType.LONG_TYPE);
                break;
            }
            case "REAL": {
                builder.sourceType(DM_REAL);
                builder.dataType((SeaTunnelDataType)BasicType.FLOAT_TYPE);
                break;
            }
            case "FLOAT": {
                builder.sourceType(DM_FLOAT);
                builder.dataType((SeaTunnelDataType)BasicType.DOUBLE_TYPE);
                break;
            }
            case "DOUBLE": {
                builder.sourceType(DM_DOUBLE);
                builder.dataType((SeaTunnelDataType)BasicType.DOUBLE_TYPE);
                break;
            }
            case "DOUBLE PRECISION": {
                builder.sourceType(DM_DOUBLE_PRECISION);
                builder.dataType((SeaTunnelDataType)BasicType.DOUBLE_TYPE);
                break;
            }
            case "NUMERIC": 
            case "NUMBER": 
            case "DECIMAL": 
            case "DEC": {
                DecimalType decimalType = typeDefine.getPrecision() != null && typeDefine.getPrecision() > 0L ? new DecimalType(typeDefine.getPrecision().intValue(), typeDefine.getScale().intValue()) : new DecimalType(38, 18);
                builder.sourceType(String.format("%s(%s,%s)", DM_DECIMAL, decimalType.getPrecision(), decimalType.getScale()));
                builder.dataType((SeaTunnelDataType)decimalType);
                builder.columnLength(Long.valueOf(decimalType.getPrecision()));
                builder.scale(Integer.valueOf(decimalType.getScale()));
                break;
            }
            case "CHAR": 
            case "CHARACTER": {
                builder.sourceType(String.format("%s(%s)", DM_CHAR, typeDefine.getLength()));
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(TypeDefineUtils.charTo4ByteLength(typeDefine.getLength()));
                break;
            }
            case "VARCHAR": 
            case "VARCHAR2": {
                builder.sourceType(String.format("%s(%s)", DM_VARCHAR2, typeDefine.getLength()));
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(TypeDefineUtils.charTo4ByteLength(typeDefine.getLength()));
                break;
            }
            case "TEXT": {
                builder.sourceType(DM_TEXT);
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(typeDefine.getLength());
                break;
            }
            case "LONG": {
                builder.sourceType(DM_LONG);
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(typeDefine.getLength());
                break;
            }
            case "LONGVARCHAR": {
                builder.sourceType(DM_LONGVARCHAR);
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(typeDefine.getLength());
                break;
            }
            case "CLOB": {
                builder.sourceType(DM_CLOB);
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(typeDefine.getLength());
                break;
            }
            case "BINARY": {
                builder.sourceType(String.format("%s(%s)", DM_BINARY, typeDefine.getLength()));
                builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                builder.columnLength(typeDefine.getLength());
                break;
            }
            case "VARBINARY": {
                builder.sourceType(String.format("%s(%s)", DM_VARBINARY, typeDefine.getLength()));
                builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                builder.columnLength(typeDefine.getLength());
                break;
            }
            case "LONGVARBINARY": {
                builder.sourceType(DM_LONGVARBINARY);
                builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                builder.columnLength(typeDefine.getLength());
                break;
            }
            case "IMAGE": {
                builder.sourceType(DM_IMAGE);
                builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                builder.columnLength(typeDefine.getLength());
                break;
            }
            case "BLOB": {
                builder.sourceType(DM_BLOB);
                builder.dataType((SeaTunnelDataType)PrimitiveByteArrayType.INSTANCE);
                builder.columnLength(typeDefine.getLength());
                break;
            }
            case "BFILE": {
                builder.sourceType(DM_BFILE);
                builder.dataType((SeaTunnelDataType)BasicType.STRING_TYPE);
                builder.columnLength(typeDefine.getLength());
                break;
            }
            case "DATE": {
                builder.sourceType(DM_DATE);
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TYPE);
                break;
            }
            case "TIME": {
                if (typeDefine.getScale() == null) {
                    builder.sourceType(DM_TIME);
                } else {
                    builder.sourceType(String.format("%s(%s)", DM_TIME, typeDefine.getScale()));
                }
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_TIME_TYPE);
                builder.scale(typeDefine.getScale());
                break;
            }
            case "TIME WITH TIME ZONE": {
                if (typeDefine.getScale() == null) {
                    builder.sourceType(DM_TIME_WITH_TIME_ZONE);
                } else {
                    builder.sourceType(String.format("TIME(%s) WITH TIME ZONE", typeDefine.getScale()));
                }
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_TIME_TYPE);
                builder.scale(typeDefine.getScale());
                break;
            }
            case "TIMESTAMP": {
                if (typeDefine.getScale() == null) {
                    builder.sourceType(DM_TIMESTAMP);
                } else {
                    builder.sourceType(String.format("%s(%s)", DM_TIMESTAMP, typeDefine.getScale()));
                }
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TIME_TYPE);
                builder.scale(typeDefine.getScale());
                break;
            }
            case "DATETIME": {
                if (typeDefine.getScale() == null) {
                    builder.sourceType(DM_DATETIME);
                } else {
                    builder.sourceType(String.format("%s(%s)", DM_DATETIME, typeDefine.getScale()));
                }
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TIME_TYPE);
                builder.scale(typeDefine.getScale());
                break;
            }
            case "DATETIME WITH TIME ZONE": {
                if (typeDefine.getScale() == null) {
                    builder.sourceType(DM_DATETIME_WITH_TIME_ZONE);
                } else {
                    builder.sourceType(String.format("DATETIME(%s) WITH TIME ZONE", typeDefine.getScale()));
                }
                builder.dataType((SeaTunnelDataType)LocalTimeType.LOCAL_DATE_TIME_TYPE);
                builder.scale(typeDefine.getScale());
                break;
            }
            default: {
                throw CommonError.convertToSeaTunnelTypeError((String)"Dameng", (String)typeDefine.getDataType(), (String)typeDefine.getName());
            }
        }
        return builder.build();
    }

    public BasicTypeDefine reconvert(Column column) {
        BasicTypeDefine.BasicTypeDefineBuilder builder = BasicTypeDefine.builder().name(column.getName()).nullable(column.isNullable()).comment(column.getComment()).defaultValue(column.getDefaultValue());
        switch (column.getDataType().getSqlType()) {
            case BOOLEAN: {
                builder.columnType(DM_BIT);
                builder.dataType(DM_BIT);
                break;
            }
            case TINYINT: {
                builder.columnType(DM_TINYINT);
                builder.dataType(DM_TINYINT);
                break;
            }
            case SMALLINT: {
                builder.columnType(DM_SMALLINT);
                builder.dataType(DM_SMALLINT);
                break;
            }
            case INT: {
                builder.columnType(DM_INT);
                builder.dataType(DM_INT);
                break;
            }
            case BIGINT: {
                builder.columnType(DM_BIGINT);
                builder.dataType(DM_BIGINT);
                break;
            }
            case FLOAT: {
                builder.columnType(DM_REAL);
                builder.dataType(DM_REAL);
                break;
            }
            case DOUBLE: {
                builder.columnType(DM_DOUBLE);
                builder.dataType(DM_DOUBLE);
                break;
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)column.getDataType();
                long precision = decimalType.getPrecision();
                int scale = decimalType.getScale();
                if (precision <= 0L) {
                    precision = 38L;
                    scale = 18;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which is precision less than 0, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), precision, scale});
                } else if (precision > 38L) {
                    scale = (int)Math.max(0L, (long)scale - (precision - 38L));
                    precision = 38L;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which exceeds the maximum precision of {}, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), 38, precision, scale});
                }
                if (scale < 0) {
                    scale = 0;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which is scale less than 0, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), precision, scale});
                } else if (scale > 37) {
                    scale = 37;
                    log.warn("The decimal column {} type decimal({},{}) is out of range, which exceeds the maximum scale of {}, it will be converted to decimal({},{})", new Object[]{column.getName(), decimalType.getPrecision(), decimalType.getScale(), 37, precision, scale});
                }
                builder.columnType(String.format("%s(%s,%s)", DM_DECIMAL, precision, scale));
                builder.dataType(DM_DECIMAL);
                builder.precision(Long.valueOf(precision));
                builder.scale(Integer.valueOf(scale));
                break;
            }
            case STRING: {
                builder.length(column.getColumnLength());
                if (column.getColumnLength() == null || column.getColumnLength() <= 0L) {
                    builder.columnType(DM_TEXT);
                    builder.dataType(DM_TEXT);
                    break;
                }
                if (column.getColumnLength() <= 1900L) {
                    builder.columnType(String.format("%s(%s)", DM_VARCHAR2, column.getColumnLength()));
                    builder.dataType(DM_VARCHAR2);
                    break;
                }
                builder.columnType(DM_TEXT);
                builder.dataType(DM_TEXT);
                break;
            }
            case BYTES: {
                builder.length(column.getColumnLength());
                if (column.getColumnLength() == null || column.getColumnLength() <= 0L) {
                    builder.columnType(DM_LONGVARBINARY);
                    builder.dataType(DM_LONGVARBINARY);
                    break;
                }
                if (column.getColumnLength() <= 1900L) {
                    builder.columnType(String.format("%s(%s)", DM_VARBINARY, column.getColumnLength()));
                    builder.dataType(DM_VARBINARY);
                    break;
                }
                builder.columnType(DM_LONGVARBINARY);
                builder.dataType(DM_LONGVARBINARY);
                break;
            }
            case DATE: {
                builder.columnType(DM_DATE);
                builder.dataType(DM_DATE);
                break;
            }
            case TIME: {
                builder.dataType(DM_TIME);
                if (column.getScale() != null && column.getScale() > 0) {
                    Integer timeScale = column.getScale();
                    if (timeScale > 6) {
                        timeScale = 6;
                        log.warn("The time column {} type time({}) is out of range, which exceeds the maximum scale of {}, it will be converted to time({})", new Object[]{column.getName(), column.getScale(), 37, timeScale});
                    }
                    builder.columnType(String.format("%s(%s)", DM_TIME, timeScale));
                    builder.scale(timeScale);
                    break;
                }
                builder.columnType(DM_TIME);
                break;
            }
            case TIMESTAMP: {
                builder.dataType(DM_TIMESTAMP);
                if (column.getScale() != null && column.getScale() > 0) {
                    Integer timestampScale = column.getScale();
                    if (timestampScale > 6) {
                        timestampScale = 6;
                        log.warn("The timestamp column {} type timestamp({}) is out of range, which exceeds the maximum scale of {}, it will be converted to timestamp({})", new Object[]{column.getName(), column.getScale(), 6, timestampScale});
                    }
                    builder.columnType(String.format("%s(%s)", DM_TIMESTAMP, timestampScale));
                    builder.scale(timestampScale);
                    break;
                }
                builder.columnType(DM_TIMESTAMP);
                break;
            }
            default: {
                throw CommonError.convertToConnectorTypeError((String)"Dameng", (String)column.getDataType().toString(), (String)column.getName());
            }
        }
        return builder.build();
    }
}

