/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.tidb;

import com.google.auto.service.AutoService;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.mysql.cj.MysqlType;
import java.util.Collections;
import java.util.Map;
import org.apache.seatunnel.api.table.catalog.DataTypeConvertor;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelRuntimeException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.mysql.MysqlDataTypeConvertor;

@Deprecated
@AutoService(value={DataTypeConvertor.class})
public class TiDBDataTypeConvertor
implements DataTypeConvertor<MysqlType> {
    public static final String PRECISION = "precision";
    public static final String SCALE = "scale";
    public static final Integer DEFAULT_PRECISION = 10;
    public static final Integer DEFAULT_SCALE = 0;
    private static final MysqlDataTypeConvertor MYSQL_CONVERTOR = new MysqlDataTypeConvertor();

    public SeaTunnelDataType<?> toSeaTunnelType(String field, String connectorDataType) {
        Map<String, Object> dataTypeProperties;
        Preconditions.checkNotNull(connectorDataType, "connectorDataType can not be null");
        MysqlType mysqlType = MysqlType.getByName((String)connectorDataType);
        switch (mysqlType) {
            case BIGINT_UNSIGNED: 
            case DECIMAL: 
            case DECIMAL_UNSIGNED: 
            case BIT: {
                int left = connectorDataType.indexOf("(");
                int right = connectorDataType.indexOf(")");
                int precision = DEFAULT_PRECISION;
                int scale = DEFAULT_SCALE;
                if (left != -1 && right != -1) {
                    String[] precisionAndScale = connectorDataType.substring(left + 1, right).split(",");
                    if (precisionAndScale.length == 2) {
                        precision = Integer.parseInt(precisionAndScale[0]);
                        scale = Integer.parseInt(precisionAndScale[1]);
                    } else if (precisionAndScale.length == 1) {
                        precision = Integer.parseInt(precisionAndScale[0]);
                    }
                }
                dataTypeProperties = ImmutableMap.of(PRECISION, precision, SCALE, scale);
                break;
            }
            default: {
                dataTypeProperties = Collections.emptyMap();
            }
        }
        return this.toSeaTunnelType(field, mysqlType, dataTypeProperties);
    }

    public SeaTunnelDataType<?> toSeaTunnelType(String field, MysqlType mysqlType, Map<String, Object> dataTypeProperties) {
        try {
            return MYSQL_CONVERTOR.toSeaTunnelType(field, mysqlType, dataTypeProperties);
        }
        catch (SeaTunnelRuntimeException e) {
            if (CommonErrorCode.CONVERT_TO_SEATUNNEL_TYPE_ERROR_SIMPLE.equals((Object)e.getSeaTunnelErrorCode())) {
                throw CommonError.convertToSeaTunnelTypeError((String)"TiDB", (String)mysqlType.getName(), (String)field);
            }
            throw e;
        }
    }

    public MysqlType toConnectorType(String field, SeaTunnelDataType<?> seaTunnelDataType, Map<String, Object> dataTypeProperties) {
        try {
            return MYSQL_CONVERTOR.toConnectorType(field, seaTunnelDataType, dataTypeProperties);
        }
        catch (SeaTunnelRuntimeException e) {
            if (CommonErrorCode.CONVERT_TO_CONNECTOR_TYPE_ERROR_SIMPLE.equals((Object)e.getSeaTunnelErrorCode())) {
                throw CommonError.convertToConnectorTypeError((String)"TiDB", (String)seaTunnelDataType.getSqlType().name(), (String)field);
            }
            throw e;
        }
    }

    public String getIdentity() {
        return "TiDB";
    }
}

