/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.argparse4j.internal;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TerminalWidth {
    private static final int UNKNOWN_WIDTH = -1;

    public static void main(String[] args) {
        System.out.println("terminalWidth: " + new TerminalWidth().getTerminalWidth());
    }

    public int getTerminalWidth() {
        String width = System.getenv("COLUMNS");
        if (width != null) {
            try {
                return Integer.parseInt(width);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        try {
            return this.getTerminalWidth2();
        }
        catch (IOException e) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTerminalWidth2() throws IOException {
        boolean isLinux;
        String osName = System.getProperty("os.name");
        boolean isOSX = osName.startsWith("Mac OS X");
        boolean bl = isLinux = osName.startsWith("Linux") || osName.startsWith("LINUX");
        if (!isLinux && !isOSX) {
            return -1;
        }
        ProcessBuilder builder = new ProcessBuilder(this.which("sh").toString(), "-c", "stty -a < /dev/tty");
        builder.redirectErrorStream(true);
        Process process = builder.start();
        InputStream in = process.getInputStream();
        ByteArrayOutputStream resultBytes = new ByteArrayOutputStream();
        try {
            int len;
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) >= 0) {
                resultBytes.write(buf, 0, len);
            }
        }
        finally {
            in.close();
        }
        String result = new String(resultBytes.toByteArray());
        try {
            if (process.waitFor() != 0) {
                return -1;
            }
        }
        catch (InterruptedException e) {
            return -1;
        }
        String pattern = isOSX ? "(\\d+) columns" : "columns (\\d+)";
        Matcher m3 = Pattern.compile(pattern).matcher(result);
        if (!m3.find()) {
            return -1;
        }
        result = m3.group(1);
        try {
            return Integer.parseInt(result);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private File which(String cmd) throws IOException {
        String path = System.getenv("PATH");
        if (path != null) {
            for (String dir : path.split(Pattern.quote(File.pathSeparator))) {
                File command = new File(dir.trim(), cmd);
                if (!command.canExecute()) continue;
                return command.getAbsoluteFile();
            }
        }
        throw new IOException("No command '" + cmd + "' on path " + path);
    }
}

