/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.jdbc;

import io.debezium.annotation.Immutable;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.util.Collect;
import java.time.Duration;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.kafka.common.config.ConfigDef;

@Immutable
public interface JdbcConfiguration
extends Configuration {
    public static final Field DATABASE = Field.create("dbname", "Name of the database");
    public static final Field USER = Field.create("user", "Name of the database user to be used when connecting to the database");
    public static final Field PASSWORD = Field.create("password", "Password to be used when connecting to the database");
    public static final Field HOSTNAME = Field.create("hostname", "IP address of the database");
    public static final Field PORT = Field.create("port", "Port of the database");
    public static final Field ON_CONNECT_STATEMENTS = Field.create("initial.statements", "A semicolon separated list of statements to be executed on connection");
    public static final Field CONNECTION_FACTORY_CLASS = Field.create("connection.factory.class").withDisplayName("Connection factory class").withDescription("(Incubating) The factory class for creation of datasource connection pool; the FQN of an implementation of io.debezium.jdbc.JdbcConnection.ConnectionFactory must be given.").withType(ConfigDef.Type.CLASS).withValidation(Field::isOptional);
    public static final Field CONNECTION_TIMEOUT_MS = Field.create("connection.timeout.ms").withDisplayName("Time to wait for a connection from the pool, given in milliseconds. Defaults to 600 seconds (600,000 ms).").withType(ConfigDef.Type.INT).withDefault(600000).withValidation(Field::isOptional);
    public static final Set<String> ALL_KNOWN_FIELDS = Collect.unmodifiableSet(Field::name, new Field[]{DATABASE, USER, PASSWORD, HOSTNAME, PORT, ON_CONNECT_STATEMENTS, CONNECTION_FACTORY_CLASS, CONNECTION_TIMEOUT_MS});

    public static JdbcConfiguration adapt(final Configuration config) {
        if (config instanceof JdbcConfiguration) {
            return (JdbcConfiguration)config;
        }
        return new JdbcConfiguration(){

            @Override
            public Set<String> keys() {
                return config.keys();
            }

            @Override
            public String getString(String key) {
                return config.getString(key);
            }

            public String toString() {
                return config.toString();
            }
        };
    }

    public static JdbcConfiguration empty() {
        return JdbcConfiguration.adapt(Configuration.empty());
    }

    public static Builder copy(final Configuration config) {
        return new Builder(){
            private Configuration.Builder builder;
            {
                this.builder = Configuration.copy(config);
            }

            @Override
            public Builder with(String key, String value) {
                this.builder.with(key, value);
                return this;
            }

            @Override
            public Builder withDefault(String key, String value) {
                this.builder.withDefault(key, value);
                return this;
            }

            @Override
            public Builder apply(Consumer<Builder> function) {
                function.accept(this);
                return this;
            }

            @Override
            public Builder changeString(Field field, Function<String, String> function) {
                this.changeString(field, (Function)function);
                return this;
            }

            @Override
            public Builder changeString(String key, Function<String, String> function) {
                this.changeString(key, (Function)function);
                return this;
            }

            @Override
            public JdbcConfiguration build() {
                return JdbcConfiguration.adapt(this.builder.build());
            }

            public String toString() {
                return this.builder.toString();
            }
        };
    }

    public static Builder create() {
        return new Builder(){
            private Configuration.Builder builder = Configuration.create();

            @Override
            public Builder with(String key, String value) {
                this.builder.with(key, value);
                return this;
            }

            @Override
            public Builder withDefault(String key, String value) {
                this.builder.withDefault(key, value);
                return this;
            }

            @Override
            public Builder apply(Consumer<Builder> function) {
                function.accept(this);
                return this;
            }

            @Override
            public Builder changeString(Field field, Function<String, String> function) {
                this.changeString(field, (Function)function);
                return this;
            }

            @Override
            public Builder changeString(String key, Function<String, String> function) {
                this.changeString(key, (Function)function);
                return this;
            }

            @Override
            public JdbcConfiguration build() {
                return JdbcConfiguration.adapt(this.builder.build());
            }

            public String toString() {
                return this.builder.toString();
            }
        };
    }

    default public Predicate<String> knownFieldNames() {
        return ALL_KNOWN_FIELDS::contains;
    }

    default public Configuration withoutKnownFields() {
        return this.filter(this.knownFieldNames().negate());
    }

    default public String getHostname() {
        return this.getString(HOSTNAME);
    }

    default public String getPortAsString() {
        return this.getString(PORT);
    }

    default public int getPort() {
        return this.getInteger(PORT);
    }

    default public String getDatabase() {
        return this.getString(DATABASE);
    }

    default public String getUser() {
        return this.getString(USER);
    }

    default public String getPassword() {
        return this.getString(PASSWORD);
    }

    default public String getConnectionFactoryClassName() {
        return this.getString(CONNECTION_FACTORY_CLASS);
    }

    default public Duration getConnectionTimeout() {
        return Duration.ofMillis(this.getInteger(CONNECTION_TIMEOUT_MS));
    }

    public static interface Builder
    extends Configuration.ConfigBuilder<JdbcConfiguration, Builder> {
        default public Builder withUser(String username) {
            return (Builder)this.with(USER, username);
        }

        default public Builder withPassword(String password) {
            return (Builder)this.with(PASSWORD, password);
        }

        default public Builder withHostname(String hostname) {
            return (Builder)this.with(HOSTNAME, hostname);
        }

        default public Builder withDatabase(String databaseName) {
            return (Builder)this.with(DATABASE, databaseName);
        }

        default public Builder withPort(int port) {
            return (Builder)this.with(PORT, port);
        }

        default public Builder withConnectionFactoryClass(String connectionFactoryClass) {
            return (Builder)this.with(CONNECTION_FACTORY_CLASS, connectionFactoryClass);
        }

        default public Builder withConnectionTimeoutMs(int connectionTimeoutMs) {
            return (Builder)this.with(CONNECTION_TIMEOUT_MS, connectionTimeoutMs);
        }
    }
}

