/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.inceptor;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.hive.HiveJdbcRowConverter;

public class InceptorJdbcRowConverter
extends HiveJdbcRowConverter {
    @Override
    public String converterName() {
        return "Inceptor";
    }

    @Override
    public PreparedStatement toExternal(TableSchema tableSchema, SeaTunnelRow row, PreparedStatement statement) {
        SeaTunnelRowType rowType = tableSchema.toPhysicalRowDataType();
        for (int fieldIndex = 0; fieldIndex < rowType.getTotalFields(); ++fieldIndex) {
            try {
                SeaTunnelDataType seaTunnelDataType = rowType.getFieldType(fieldIndex);
                int statementIndex = fieldIndex + 1;
                Object fieldValue = row.getField(fieldIndex);
                if (fieldValue == null) {
                    statement.setObject(statementIndex, "");
                    continue;
                }
                switch (seaTunnelDataType.getSqlType()) {
                    case STRING: {
                        statement.setString(statementIndex, (String)row.getField(fieldIndex));
                        break;
                    }
                    case BOOLEAN: {
                        statement.setBoolean(statementIndex, (Boolean)row.getField(fieldIndex));
                        break;
                    }
                    case TINYINT: {
                        statement.setByte(statementIndex, (Byte)row.getField(fieldIndex));
                        break;
                    }
                    case SMALLINT: {
                        statement.setShort(statementIndex, (Short)row.getField(fieldIndex));
                        break;
                    }
                    case INT: {
                        statement.setInt(statementIndex, (Integer)row.getField(fieldIndex));
                        break;
                    }
                    case BIGINT: {
                        statement.setLong(statementIndex, (Long)row.getField(fieldIndex));
                        break;
                    }
                    case FLOAT: {
                        statement.setFloat(statementIndex, ((Float)row.getField(fieldIndex)).floatValue());
                        break;
                    }
                    case DOUBLE: {
                        statement.setDouble(statementIndex, (Double)row.getField(fieldIndex));
                        break;
                    }
                    case DECIMAL: {
                        statement.setBigDecimal(statementIndex, (BigDecimal)row.getField(fieldIndex));
                        break;
                    }
                    case DATE: {
                        LocalDate localDate = (LocalDate)row.getField(fieldIndex);
                        statement.setDate(statementIndex, Date.valueOf(localDate));
                        break;
                    }
                    case TIME: {
                        this.writeTime(statement, statementIndex, (LocalTime)row.getField(fieldIndex));
                        break;
                    }
                    case TIMESTAMP: {
                        LocalDateTime localDateTime = (LocalDateTime)row.getField(fieldIndex);
                        statement.setTimestamp(statementIndex, Timestamp.valueOf(localDateTime));
                        break;
                    }
                    case BYTES: {
                        statement.setBytes(statementIndex, (byte[])row.getField(fieldIndex));
                        break;
                    }
                    case NULL: {
                        statement.setNull(statementIndex, 0);
                        break;
                    }
                    case ARRAY: {
                        SeaTunnelDataType elementType = ((ArrayType)seaTunnelDataType).getElementType();
                        Object[] array = (Object[])row.getField(fieldIndex);
                        if (array == null) {
                            statement.setNull(statementIndex, 2003);
                            break;
                        }
                        if (SqlType.TINYINT.equals((Object)elementType.getSqlType())) {
                            Short[] shortArray = new Short[array.length];
                            for (int i = 0; i < array.length; ++i) {
                                shortArray[i] = Short.valueOf(array[i].toString());
                            }
                            statement.setObject(statementIndex, shortArray);
                            break;
                        }
                        statement.setObject(statementIndex, array);
                        break;
                    }
                    default: {
                        throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, "Unexpected value: " + seaTunnelDataType);
                    }
                }
                continue;
            }
            catch (Exception e) {
                throw new JdbcConnectorException(JdbcConnectorErrorCode.DATA_TYPE_CAST_FAILED, "error field:" + rowType.getFieldNames()[fieldIndex], e);
            }
        }
        return statement;
    }
}

