/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.oracle;

import com.google.auto.service.AutoService;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.MapUtils;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.DataTypeConvertor;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.oracle.OracleTypeConverter;

@Deprecated
@AutoService(value={DataTypeConvertor.class})
public class OracleDataTypeConvertor
implements DataTypeConvertor<String> {
    public static final String PRECISION = "precision";
    public static final String SCALE = "scale";
    public static final Long DEFAULT_PRECISION = 38L;
    public static final Integer DEFAULT_SCALE = 18;

    public SeaTunnelDataType<?> toSeaTunnelType(String field, String connectorDataType) {
        return this.toSeaTunnelType(field, connectorDataType, Collections.emptyMap());
    }

    public SeaTunnelDataType<?> toSeaTunnelType(String field, String connectorDataType, Map<String, Object> dataTypeProperties) {
        Preconditions.checkNotNull(connectorDataType, "Oracle Type cannot be null");
        Long precision = null;
        Integer scale = null;
        switch (connectorDataType) {
            case "NUMBER": {
                precision = MapUtils.getLong(dataTypeProperties, (Object)PRECISION, (Long)DEFAULT_PRECISION);
                scale = MapUtils.getInteger(dataTypeProperties, (Object)SCALE, (Integer)DEFAULT_SCALE);
                break;
            }
        }
        BasicTypeDefine typeDefine = BasicTypeDefine.builder().name(field).columnType(connectorDataType).dataType(OracleDataTypeConvertor.normalizeTimestamp(connectorDataType)).length(precision).precision(precision).scale(scale).build();
        return OracleTypeConverter.INSTANCE.convert(typeDefine).getDataType();
    }

    public String toConnectorType(String field, SeaTunnelDataType<?> seaTunnelDataType, Map<String, Object> dataTypeProperties) {
        Preconditions.checkNotNull(seaTunnelDataType, "seaTunnelDataType cannot be null");
        Long precision = MapUtils.getLong(dataTypeProperties, (Object)PRECISION);
        Integer scale = MapUtils.getInteger(dataTypeProperties, (Object)SCALE);
        PhysicalColumn column = PhysicalColumn.builder().name(field).dataType(seaTunnelDataType).columnLength(precision).scale(scale).nullable(true).build();
        BasicTypeDefine typeDefine = OracleTypeConverter.INSTANCE.reconvert((Column)column);
        return typeDefine.getColumnType();
    }

    public static String normalizeTimestamp(String oracleType) {
        String pattern = "^TIMESTAMP(\\([0-9]\\))?$";
        Pattern r = Pattern.compile(pattern);
        Matcher m3 = r.matcher(oracleType);
        if (m3.find()) {
            return "TIMESTAMP";
        }
        return oracleType;
    }

    public String getIdentity() {
        return "Oracle";
    }
}

